# ================================================================ Rules Engine
project      = Project.last
tag_critical = project.tags.find_by(name: '!9467bd_critical').try(:name)
tag_high     = project.tags.find_by(name: '!d62728_high').try(:name)
tag_medium   = project.tags.find_by(name: '!ff7f0e_medium').try(:name)
tag_low      = project.tags.find_by(name: '!6baed6_low').try(:name)
tag_info     = project.tags.find_by(name: '!2ca02c_info').try(:name)

if Dradis::Pro::Rules::Rules::AndRule.where(name: 'Nessus N/A CVSS to 0.0').empty?
  nessus1 = Dradis::Pro::Rules::Rules::AndRule.create!(name: 'Nessus N/A CVSS to 0.0')
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus1, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '==', value: 'n/a' })
  Dradis::Pro::Rules::Actions::ChangeValueAction.create!(rule: nessus1, properties: { field: 'CVSSv3.BaseScore', new_value: '0.0' })
end

if Dradis::Pro::Rules::Rules::AndRule.where(name: 'Nessus: Tag Critical').empty?
  nessus2 = Dradis::Pro::Rules::Rules::AndRule.create!(name: 'Nessus: Tag Critical')
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus2, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '>=', value: '9.0' })
  Dradis::Pro::Rules::Actions::TagAction.create!(rule: nessus2, properties: { tag_name: tag_critical })
end

if Dradis::Pro::Rules::Rules::AndRule.where(name: 'Nessus: Tag High').empty?
  nessus3 = Dradis::Pro::Rules::Rules::AndRule.create!(name: 'Nessus: Tag High')
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus3, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '<=', value: '8.9' })
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus3, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '>=', value: '7.0' })
  Dradis::Pro::Rules::Actions::TagAction.create!(rule: nessus3, properties: { tag_name: tag_high })
end

if Dradis::Pro::Rules::Rules::AndRule.where(name: 'Nessus: Tag Medium').empty?
  nessus4 = Dradis::Pro::Rules::Rules::AndRule.create!(name: 'Nessus: Tag Medium')
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus4, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '<=', value: '6.9' })
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus4, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '>=', value: '4.0' })
  Dradis::Pro::Rules::Actions::TagAction.create!(rule: nessus4, properties: { tag_name: tag_medium })
end

if Dradis::Pro::Rules::Rules::AndRule.where(name: 'Nessus: Tag Low').empty?
  nessus5 = Dradis::Pro::Rules::Rules::AndRule.create!(name: 'Nessus: Tag Low')
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus5, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '<=', value: '3.9' })
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus5, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '>=', value: '0.1' })
  Dradis::Pro::Rules::Actions::TagAction.create!(rule: nessus5, properties: { tag_name: tag_low })
end

if Dradis::Pro::Rules::Rules::AndRule.where(name: 'Nessus: Tag Info').empty?
  nessus6 = Dradis::Pro::Rules::Rules::AndRule.create!(name: 'Nessus: Tag Info')
  Dradis::Pro::Rules::Conditions::FieldCondition.create!(rule: nessus6, properties: { plugin: :nessus, field: 'CVSSv3.BaseScore', operator: '==', value: '0.0' })
  Dradis::Pro::Rules::Actions::TagAction.create!(rule: nessus6, properties: { tag_name: tag_info })
end
