/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureManifestParser;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.pde.internal.publishing.Activator;
import org.xml.sax.SAXException;

public class FeatureParser {
    private final FeatureManifestParser parser = new FeatureManifestParser();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Feature parse(File location) {
        if (!location.exists()) {
            return null;
        }
        Feature feature = null;
        if (location.isDirectory()) {
            File file = new File(location, "feature.xml");
            try {
                Throwable throwable = null;
                Object var5_16 = null;
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                    feature = this.parser.parse(input, FeatureParser.toURL(location));
                    if (feature == null) return feature;
                    List<String> messageKeys = this.parser.getMessageKeys();
                    String[] keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                    feature.setLocalizations(LocalizationHelper.getDirPropertyLocalizations((File)location, (String)"feature", null, (String[])keyStrings));
                    return feature;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (SAXException e) {
                FeatureParser.logWarning(location, e);
                return feature;
            }
            catch (IOException e) {
                FeatureParser.logWarning(location, e);
                return feature;
            }
        }
        if (!location.getName().endsWith(".jar")) return feature;
        try {
            Throwable file = null;
            Object var4_14 = null;
            try (JarFile jar = new JarFile(location);){
                JarEntry entry = jar.getJarEntry("feature.xml");
                if (entry == null) {
                    return null;
                }
                BufferedInputStream input = new BufferedInputStream(jar.getInputStream(entry));
                feature = this.parser.parse(input, FeatureParser.toURL(location));
                if (feature == null) return feature;
                List<String> messageKeys = this.parser.getMessageKeys();
                String[] keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                feature.setLocalizations(LocalizationHelper.getJarPropertyLocalizations((File)location, (String)"feature", null, (String[])keyStrings));
                return feature;
            }
            catch (Throwable throwable) {
                if (file == null) {
                    file = throwable;
                    throw file;
                }
                if (file == throwable) throw file;
                file.addSuppressed(throwable);
                throw file;
            }
        }
        catch (SAXException e) {
            FeatureParser.logWarning(location, e);
            return feature;
        }
        catch (IOException e) {
            FeatureParser.logWarning(location, e);
            return feature;
        }
        catch (SecurityException e) {
            FeatureParser.logWarning(location, e);
        }
        return feature;
    }

    private static void logWarning(File location, Exception exception) {
        LogHelper.log((IStatus)new Status(2, Activator.ID, "Exception parsing feature: " + location.getAbsolutePath(), (Throwable)exception));
    }

    private static URL toURL(File location) {
        try {
            return location.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

