/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;

public final class OpenAIModels {
    public static final String DEFAULT_MODEL = "gpt-4o";
    public static final Map<String, AIModel> KNOWN_MODELS = Stream.of(new AIModel("o4-mini", 200000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("o3-pro", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("o3", 200000, Set.of(AIModelFeature.CHAT, AIModelFeature.ALWAYS_DEFAULT_TEMPERATURE), 1.0), new AIModel("o3-mini", 200000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING, AIModelFeature.ALWAYS_DEFAULT_TEMPERATURE), 1.0), new AIModel("o1-pro", 200000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("o1", 200000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("o1-mini", 128000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("gpt-5", 400000, Set.of(AIModelFeature.CHAT, AIModelFeature.ALWAYS_DEFAULT_TEMPERATURE), 1.0), new AIModel("gpt-5-mini", 400000, Set.of(AIModelFeature.CHAT, AIModelFeature.ALWAYS_DEFAULT_TEMPERATURE), 1.0), new AIModel("gpt-5-nano", 400000, Set.of(AIModelFeature.CHAT, AIModelFeature.ALWAYS_DEFAULT_TEMPERATURE), 1.0), new AIModel("gpt-4.1", 0x100000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("gpt-4o", 128000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("gpt-4o-mini", 128000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("gpt-4-turbo", 128000, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("gpt-3.5-turbo", 16384, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("gpt-4", 8192, Set.of(AIModelFeature.CHAT, AIModelFeature.STREAMING)), new AIModel("gpt-4o-transcribe", 128000, Set.of(AIModelFeature.SPEECH_TO_TEXT)), new AIModel("gpt-4o-mini-transcribe", 128000, Set.of(AIModelFeature.SPEECH_TO_TEXT)), new AIModel("whisper-1", 30000, Set.of(AIModelFeature.SPEECH_TO_TEXT))).collect(Collectors.toMap(AIModel::name, Function.identity()));
    public static final Set<String> DEPRECATED_MODELS = Set.of("gpt-3.5-turbo-0301", "gpt-3.5-turbo-0613", "gpt-3.5-turbo-1106", "gpt-3.5-turbo-16k", "gpt-3.5-turbo-16k-0613", "gpt-3.5-turbo-16k-1106");
    private static final List<String> CHAT_EXCLUDED_KEYWORDS = List.of("search", "research", "moderation", "realtime", "audio", "image");

    private OpenAIModels() {
    }

    public static String getEffectiveModelName(@Nullable String modelName) {
        if (modelName == null || modelName.isEmpty()) {
            return DEFAULT_MODEL;
        }
        String lowerCaseModelName = modelName.toLowerCase(Locale.ROOT);
        if (KNOWN_MODELS.containsKey(lowerCaseModelName)) {
            return lowerCaseModelName;
        }
        if (DEPRECATED_MODELS.contains(lowerCaseModelName)) {
            return DEFAULT_MODEL;
        }
        return modelName;
    }

    @NotNull
    public static Optional<AIModel> getModelByName(@Nullable String modelName) {
        if (modelName == null || modelName.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(KNOWN_MODELS.get(modelName.toLowerCase(Locale.ROOT)));
    }

    public static Set<AIModelFeature> detectModelFeatures(@NotNull String modelName) {
        AIModel knownModel = KNOWN_MODELS.get(modelName.toLowerCase(Locale.ROOT));
        if (knownModel != null) {
            return knownModel.features();
        }
        HashSet<AIModelFeature> features = new HashSet<AIModelFeature>();
        if (OpenAIModels.isChatModel(modelName)) {
            features.add(AIModelFeature.CHAT);
            features.add(AIModelFeature.STREAMING);
        }
        return features;
    }

    private static boolean isChatModel(@NotNull String modelName) {
        if (!modelName.startsWith("gpt-") && !modelName.startsWith("o")) {
            return false;
        }
        for (String keyword : CHAT_EXCLUDED_KEYWORDS) {
            if (!modelName.contains(keyword)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTemperatureEditable(@NotNull AIModel model) {
        return !model.features().contains((Object)AIModelFeature.ALWAYS_DEFAULT_TEMPERATURE);
    }
}

