/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.core.runtime.Plugin;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RegistryActivator
extends Plugin {
    public void start(@NotNull BundleContext context) throws Exception {
        super.start(context);
        RegistryActivator.setJnaNativePath(context);
    }

    private static void setJnaNativePath(@NotNull BundleContext context) {
        String installPath = SystemVariablesResolver.getInstallPath();
        Path pluginsPath = Path.of(installPath, new String[0]).resolve("plugins");
        Bundle jnaBundle = Arrays.stream(context.getBundles()).filter(b -> "com.sun.jna".equals(b.getSymbolicName())).findFirst().orElse(null);
        if (jnaBundle != null) {
            String bundleFolderName;
            Path jnaBundlePath;
            String location = jnaBundle.getLocation();
            int divPos = (location = CommonUtils.removeTrailingSlash((String)location)).lastIndexOf("/");
            if (divPos != -1 && Files.exists(jnaBundlePath = pluginsPath.resolve(bundleFolderName = location.substring(divPos + 1)).resolve("com/sun/jna"), new LinkOption[0])) {
                String osName = null;
                if (RuntimeUtils.isMacOS()) {
                    osName = "darwin";
                } else if (RuntimeUtils.isLinux()) {
                    osName = "linux";
                } else if (RuntimeUtils.isWindows()) {
                    osName = "win32";
                }
                String osArch = null;
                if (RuntimeUtils.isOSArchAMD64()) {
                    osArch = "x86-64";
                } else if (RuntimeUtils.isOSArchAArch64()) {
                    osArch = "aarch64";
                }
                if (osName != null && osArch != null) {
                    System.setProperty("jna.boot.library.path", jnaBundlePath.resolve(osName + "-" + osArch).toAbsolutePath().toString());
                }
            }
        }
    }

    public void stop(@NotNull BundleContext context) throws Exception {
        super.stop(context);
    }
}

