/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSUtilities {
    private static final Logger logger = Logger.getLogger(CSSUtilities.class.getName());

    private CSSUtilities() {
    }

    public static String preProcessCss(String text) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(text));
            StringBuffer sb = new StringBuffer();
            String pendingLine = null;
            while ((line = reader.readLine()) != null) {
                String tline = line.trim();
                if (tline.length() == 0) continue;
                if (pendingLine != null) {
                    sb.append(pendingLine);
                    sb.append("\r\n");
                    pendingLine = null;
                }
                if (tline.startsWith("//")) {
                    pendingLine = line;
                    continue;
                }
                sb.append(line);
                sb.append("\r\n");
            }
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage());
        }
    }

    public static InputSource getCssInputSourceForStyleSheet(String text, String scriptURI) {
        StringReader reader = new StringReader(text);
        InputSource is = new InputSource(reader);
        is.setURI(scriptURI);
        return is;
    }

    public static CSSStyleSheet parse(Node ownerNode, String href, HTMLDocumentImpl doc, String baseUri, boolean considerDoubleSlashComments) throws MalformedURLException {
        UserAgentContext bcontext = doc.getUserAgentContext();
        final HttpRequest request = bcontext.createHttpRequest();
        URL baseURL = new URL(baseUri);
        URL scriptURL = Urls.createURL(baseURL, href);
        final String scriptURI = scriptURL == null ? href : scriptURL.toExternalForm();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            try {
                request.open("GET", scriptURI, false);
                request.send(null);
            }
            catch (IOException thrown) {
                logger.log(Level.WARNING, "parse()", thrown);
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        request.open("GET", scriptURI, false);
                        request.send(null);
                    }
                    catch (IOException thrown) {
                        logger.log(Level.WARNING, "parse()", thrown);
                    }
                    return null;
                }
            });
        }
        int status = request.getStatus();
        if (status != 200 && status != 0) {
            logger.warning("Unable to parse CSS. URI=[" + scriptURI + "]. Response status was " + status + ".");
            return null;
        }
        String text = request.getResponseText();
        if (text != null && !"".equals(text)) {
            String processedText = considerDoubleSlashComments ? CSSUtilities.preProcessCss(text) : text;
            CSSOMParser parser = new CSSOMParser();
            InputSource is = CSSUtilities.getCssInputSourceForStyleSheet(processedText, scriptURI);
            is.setURI(scriptURI);
            try {
                CSSStyleSheetImpl sheet = (CSSStyleSheetImpl)parser.parseStyleSheet(is);
                sheet.setHref(scriptURI);
                sheet.setOwnerNode(ownerNode);
                return sheet;
            }
            catch (Throwable err) {
                logger.log(Level.WARNING, "Unable to parse CSS. URI=[" + scriptURI + "].", err);
                return null;
            }
        }
        return null;
    }

    public static boolean matchesMedia(String mediaValues, UserAgentContext rcontext) {
        if (mediaValues == null || mediaValues.length() == 0) {
            return true;
        }
        if (rcontext == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(mediaValues, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            String mediaName = Strings.trimForAlphaNumDash(token);
            if (!rcontext.isMedia(mediaName)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesMedia(MediaList mediaList, UserAgentContext rcontext) {
        if (mediaList == null) {
            return true;
        }
        int length = mediaList.getLength();
        if (length == 0) {
            return true;
        }
        if (rcontext == null) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            String mediaName = mediaList.item(i);
            if (!rcontext.isMedia(mediaName)) continue;
            return true;
        }
        return false;
    }
}

