/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.list.bundle;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.detailview.list.LinkListDetailView;
import com.paterva.maltego.treelist.parts.PartsRowModel;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import com.paterva.maltego.treelist.parts.link.LinkTable;
import com.paterva.maltego.ui.graph.actions.NodeEditor;
import com.paterva.maltego.ui.graph.find.ViewControlAdapterFocusFind;
import com.paterva.maltego.util.ui.ComponentFlasher;
import com.paterva.maltego.view.list.bundle.LinkListViewTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;

public final class LinkListViewDetailView
extends LinkListDetailView
implements ViewControlAdapterFocusFind {
    public LinkListViewDetailView() {
        TableColumn col = this.getTable().getColumnModel().getColumn(0);
        col.setMinWidth(0);
        col.setPreferredWidth(0);
        col.setMaxWidth(0);
        Dimension cpDim = new Dimension(0, 0);
        JPanel cp = this.getCornerPanel();
        cp.setMinimumSize(cpDim);
        cp.setPreferredSize(cpDim);
        cp.setMaximumSize(cpDim);
        Color bg = new JPanel().getBackground();
        Dimension fpDim = new Dimension(300, Math.max(30, new JTextField().getPreferredSize().height));
        JPanel fp = this.getFilterPanel();
        fp.setBackground(bg);
        fp.setBorder(new EmptyBorder(1, 0, 1, 0));
        fp.setMinimumSize(fpDim);
        fp.setPreferredSize(fpDim);
        fp.setMaximumSize(fpDim);
        JPanel tp = this.getTopPanel();
        tp.setBackground(bg);
        tp.setLayout(new BoxLayout(tp, 0));
    }

    public void setSelectedLinks(Set<LinkID> links) {
        LinkTable table = this.getTable();
        final ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.clearSelection();
        PartsRowModel rowModel = table.getRowModel();
        PartsTreelistModel model = rowModel.getModel();
        final ArrayList<Integer> indexes = new ArrayList<Integer>();
        List list = model.getSortedFilteredPartIDs();
        for (int i = 0; i < list.size(); ++i) {
            LinkID linkID = (LinkID)list.get(i);
            if (!links.contains(linkID)) continue;
            indexes.add(i);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                selectionModel.setValueIsAdjusting(true);
                for (Integer i : indexes) {
                    selectionModel.addSelectionInterval(i, i);
                }
                selectionModel.setValueIsAdjusting(false);
            }
        });
    }

    protected JComponent createCornerComponent() {
        JLabel label = new JLabel(" Filter:  ");
        Font font = label.getFont();
        label.setFont(new Font(font.getFontName(), 1, font.getSize()));
        label.setBackground(UIManager.getLookAndFeelDefaults().getColor("parts-table-header-bg"));
        label.setOpaque(true);
        return label;
    }

    protected LinkTable createLinkTable(String name) {
        return new LinkListViewTable(name);
    }

    protected MouseAdapter createClickEditListener() {
        return new ClickEditListener();
    }

    public void focusAndFlashFind() {
        for (Component comp : this.getFilterPanel().getComponents()) {
            if (!(comp instanceof JTextField)) continue;
            JTextField field = (JTextField)comp;
            field.requestFocusInWindow();
            ComponentFlasher.flash((Component)field, (Color)UIManager.getLookAndFeelDefaults().getColor("component-flasher-background-color"), (int)250, (int)4);
        }
    }

    private class ClickEditListener
    extends MouseAdapter {
        private ClickEditListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            int viewRow = LinkListViewDetailView.this.getTable().rowAtPoint(point);
            int viewColumn = LinkListViewDetailView.this.getTable().columnAtPoint(point);
            int modelRow = LinkListViewDetailView.this.getTable().convertRowIndexToModel(viewRow);
            int modelColumn = LinkListViewDetailView.this.getTable().convertColumnIndexToModel(viewColumn);
            if (modelColumn == 0 && e.getClickCount() == 2) {
                GraphID graphID = LinkListViewDetailView.this.getTable().getTreelistModel().getGraphID();
                LinkID linkId = (LinkID)LinkListViewDetailView.this.getTable().getTreeModel().getPartID(modelRow);
                NodeEditor.getDefault().edit(graphID, linkId);
            }
        }
    }
}

