/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.api.TransformServerMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

public abstract class TransformServerMapProvider {
    private static TransformServerMapProvider _default;

    public static synchronized TransformServerMapProvider getDefault() {
        if (_default == null && (_default = (TransformServerMapProvider)Lookup.getDefault().lookup(TransformServerMapProvider.class)) == null) {
            _default = new TrivialTransformServerMapProvider();
        }
        return _default;
    }

    public abstract TransformServerMap get(Collection<? extends TransformDefinition> var1, TransformServerInfo var2);

    protected TransformServerMap createMap(Map<TransformDefinition, TransformServerInfo> map) {
        return new TransformServerMap(map);
    }

    private static class TrivialTransformServerMapProvider
    extends TransformServerMapProvider {
        private TrivialTransformServerMapProvider() {
        }

        @Override
        public TransformServerMap get(Collection<? extends TransformDefinition> transforms, TransformServerInfo server) {
            HashMap<TransformDefinition, TransformServerInfo> map = new HashMap<TransformDefinition, TransformServerInfo>();
            for (TransformDefinition transformDefinition : transforms) {
                map.put(transformDefinition, server);
            }
            return this.createMap(map);
        }
    }
}

