/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.workgroup.QueueUser;
import org.xmlpull.v1.XmlPullParser;

public class QueueDetails
implements PacketExtension {
    public static final String ELEMENT_NAME = "notify-queue-details";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private static final String DATE_FORMAT = "yyyyMMdd'T'HH:mm:ss";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private Set<QueueUser> users = new HashSet<QueueUser>();

    private QueueDetails() {
    }

    public int getUserCount() {
        return this.users.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<QueueUser> getUsers() {
        Set<QueueUser> set = this.users;
        synchronized (set) {
            return this.users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUser(QueueUser user) {
        Set<QueueUser> set = this.users;
        synchronized (set) {
            this.users.add(user);
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        Set<QueueUser> set = this.users;
        synchronized (set) {
            for (QueueUser user : this.users) {
                int position = user.getQueuePosition();
                int timeRemaining = user.getEstimatedRemainingTime();
                Date timestamp = user.getQueueJoinTimestamp();
                buf.append("<user jid=\"").append(user.getUserID()).append("\">");
                if (position != -1) {
                    buf.append("<position>").append(position).append("</position>");
                }
                if (timeRemaining != -1) {
                    buf.append("<time>").append(timeRemaining).append("</time>");
                }
                if (timestamp != null) {
                    buf.append("<join-time>");
                    buf.append(this.dateFormat.format(timestamp));
                    buf.append("</join-time>");
                }
                buf.append("</user>");
            }
        }
        buf.append("</").append(ELEMENT_NAME).append(">");
        return buf.toString();
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
            SimpleDateFormat dateFormat = new SimpleDateFormat(QueueDetails.DATE_FORMAT);
            QueueDetails queueDetails = new QueueDetails();
            int eventType = parser.getEventType();
            while (eventType != 3 && QueueDetails.ELEMENT_NAME.equals(parser.getName())) {
                eventType = parser.next();
                while (eventType == 2 && "user".equals(parser.getName())) {
                    String uid = null;
                    int position = -1;
                    int time = -1;
                    Date joinTime = null;
                    uid = parser.getAttributeValue("", "jid");
                    if (uid == null) {
                        // empty if block
                    }
                    eventType = parser.next();
                    while (eventType != 3 || !"user".equals(parser.getName())) {
                        if ("position".equals(parser.getName())) {
                            position = Integer.parseInt(parser.nextText());
                        } else if ("time".equals(parser.getName())) {
                            time = Integer.parseInt(parser.nextText());
                        } else if ("join-time".equals(parser.getName())) {
                            joinTime = dateFormat.parse(parser.nextText());
                        } else if (parser.getName().equals("waitTime")) {
                            Date wait = dateFormat.parse(parser.nextText());
                            System.out.println(wait);
                        }
                        if ((eventType = parser.next()) == 3) continue;
                    }
                    queueDetails.addUser(new QueueUser(uid, position, time, joinTime));
                    eventType = parser.next();
                }
            }
            return queueDetails;
        }
    }
}

