/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

abstract class CharacterExtractorTokenFilter
extends TokenFilter {
    public static final String EXTRACTED = "extra";
    private final OffsetAttribute _offsetAttr = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute _typeAttr = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final CharTermAttribute _termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private char[] _inputBuffer = null;
    private int _inputIndex;
    private int _inputLength;

    public CharacterExtractorTokenFilter(TokenStream input) {
        super(input);
    }

    public void reset() throws IOException {
        this._inputBuffer = null;
        super.reset();
    }

    public boolean incrementToken() throws IOException {
        if (this._inputBuffer == null || this._inputIndex >= this._inputLength) {
            if (this.input.incrementToken()) {
                this._inputBuffer = this._termAttr.buffer();
                this._inputLength = this._termAttr.length();
                this._inputIndex = 0;
            } else {
                return false;
            }
        }
        int start = this._inputIndex;
        while (this._inputIndex < this._inputLength) {
            int ch = Character.codePointAt(this._inputBuffer, this._inputIndex, this._inputLength);
            if (this.isExtractableCharacter(ch)) {
                String type = "word";
                if (this._inputIndex == start) {
                    type = EXTRACTED;
                    ++this._inputIndex;
                }
                this.updateAttribute(type, start, this._inputIndex);
                return true;
            }
            ++this._inputIndex;
        }
        this.updateAttribute("word", start, this._inputIndex);
        return true;
    }

    public abstract boolean isExtractableCharacter(int var1);

    private void updateAttribute(String type, int start, int end) {
        if (start > 0) {
            System.arraycopy(this._inputBuffer, start, this._termAttr.buffer(), 0, end - start);
            end -= start;
            start = 0;
        }
        this._typeAttr.setType(type);
        this._offsetAttr.setOffset(start, end);
        this._termAttr.setLength(end - start);
    }
}

