/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.propertysheet;

import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.manager.nodes.ManagedProperty;
import com.paterva.maltego.transform.manager.nodes.TransformNode;
import com.paterva.maltego.transform.manager.nodes.TransformPropertyProxy;
import com.paterva.maltego.transform.manager.propertysheet.ManagedPropertyAdapter;
import com.paterva.maltego.typing.editing.propertygrid.DisplayDescriptorProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.nodes.Node;

public class PropertySheetPanel
extends JPanel {
    private PropertySheetView _sheet = new PropertySheetView();
    private final JCheckBox _popup = new JCheckBox("Popup");
    private final JCheckBox _internal = new JCheckBox("Internal");
    private final JCheckBox _readonly = new JCheckBox("Read-only");
    private final JLabel _nameLabel = new JLabel("Property ID");
    private final JTextField _nameTextField = new JTextField();
    private ExplorerManager _explorer;
    private PropertyChangeListener _hubSettingsListener;
    private JToolBar _toolbar;

    public PropertySheetPanel() {
        this.initComponents();
        Color bg = UIManager.getLookAndFeelDefaults().getColor("prop-sheet-bg");
        this.setBackground(bg);
        this._toolbar.setBackground(bg);
        this.add((Component)this._sheet, "Center");
        this._popup.setForeground(UIManager.getLookAndFeelDefaults().getColor("prop-sheet-set-fg"));
        this._toolbar.add(this._popup);
        this._internal.setVisible(false);
        this._toolbar.add(this._internal);
        JPanel panel = new JPanel(new BorderLayout(2, 0));
        panel.setBorder(new EmptyBorder(2, 2, 2, 0));
        panel.add((Component)this._nameLabel, "West");
        panel.add(this._nameTextField);
        this._nameTextField.setEditable(false);
        this._popup.setVisible(false);
        this._sheet.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedFeatureDescriptor".equals(evt.getPropertyName())) {
                    if (evt.getNewValue() instanceof Node.Property) {
                        Node.Property prop = (Node.Property)evt.getNewValue();
                        String name = prop.getName();
                        PropertySheetPanel.this.selectedPropertyUpdated(PropertySheetPanel.this.getSelectedProperty(name));
                        PropertySheetPanel.this._nameTextField.setText(name);
                        PropertySheetPanel.this._popup.setVisible(true);
                    } else {
                        PropertySheetPanel.this.selectedPropertyUpdated(null);
                        PropertySheetPanel.this._nameTextField.setText("");
                        PropertySheetPanel.this._popup.setVisible(false);
                    }
                }
            }
        });
        this._internal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertySheetPanel.this.internalChanged();
            }
        });
        this._popup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertySheetPanel.this.popupChanged();
            }
        });
        this._readonly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertySheetPanel.this.readonlyChanged();
            }
        });
        this.selectedPropertyUpdated(null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._hubSettingsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertySheetPanel.this.refreshSheet();
            }
        };
        HubSeedSettings.getDefault().addPropertyChangeListener(this._hubSettingsListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        HubSeedSettings.getDefault().removePropertyChangeListener(this._hubSettingsListener);
        this._hubSettingsListener = null;
    }

    private ManagedProperty getSelectedProperty(String name) {
        TransformDefinition[] transforms = this.getSelectedTransforms();
        if (transforms.length > 0) {
            ManagedProperty[] props = new ManagedProperty[transforms.length];
            for (int i = 0; i < transforms.length; ++i) {
                TransformPropertyDescriptor tpd = (TransformPropertyDescriptor)transforms[i].getProperties().get(name);
                if (tpd == null) {
                    return null;
                }
                props[i] = new TransformPropertyProxy(tpd, (TransformSettings)transforms[i]);
            }
            return new ManagedPropertyAdapter(props);
        }
        return null;
    }

    private ManagedProperty getSelectedProperty() {
        FeatureDescriptor fd = this._sheet.getSelectedProperty();
        if (fd == null) {
            return null;
        }
        return this.getSelectedProperty(fd.getName());
    }

    private void popupChanged() {
        ManagedProperty dd = this.getSelectedProperty();
        if (dd != null) {
            dd.setPopup(this._popup.isSelected());
            this.refreshSheet();
        }
    }

    private void readonlyChanged() {
        ManagedProperty dd = this.getSelectedProperty();
        if (dd != null) {
            dd.setReadonly(this._readonly.isSelected());
            this.refreshSheet();
        }
    }

    private void internalChanged() {
        ManagedProperty dd = this.getSelectedProperty();
        if (dd != null) {
            dd.setInternal(this._internal.isSelected());
            this.refreshSheet();
        }
    }

    private TransformDefinition[] getSelectedTransforms() {
        TransformNode[] nodes = this.getSelectedNodes();
        TransformDefinition[] definitions = new TransformDefinition[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            definitions[i] = (TransformDefinition)nodes[i].getLookup().lookup(TransformDefinition.class);
        }
        return definitions;
    }

    public TransformNode[] getSelectedNodes() {
        Node[] nodes = this.explorer().getSelectedNodes();
        TransformNode[] tNodes = new TransformNode[nodes.length];
        System.arraycopy(nodes, 0, tNodes, 0, nodes.length);
        return tNodes;
    }

    private ExplorerManager explorer() {
        if (this._explorer == null) {
            this._explorer = ExplorerManager.find((Component)this._sheet);
            this._explorer.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selectedNodes".equals(evt.getPropertyName())) {
                        PropertySheetPanel.this.selectedPropertyUpdated(null);
                    }
                }
            });
        }
        return this._explorer;
    }

    private void refreshSheet() {
        FeatureDescriptor fd = this._sheet.getSelectedProperty();
        boolean forceAllRefresh = true;
        if (!forceAllRefresh && fd instanceof DisplayDescriptorProperty) {
            DisplayDescriptorProperty ddp = (DisplayDescriptorProperty)fd;
            ddp.refresh();
            this._sheet.repaint();
        } else {
            TransformNode[] nodes;
            for (TransformNode node : nodes = this.getSelectedNodes()) {
                node.refreshProperties();
            }
        }
        if (fd instanceof DisplayDescriptorProperty) {
            // empty if block
        }
    }

    private void selectedPropertyUpdated(ManagedProperty fd) {
        if (fd == null) {
            this._internal.setEnabled(false);
            this._popup.setEnabled(false);
            this._readonly.setEnabled(false);
            this._internal.setSelected(false);
            this._readonly.setSelected(false);
            this._popup.setSelected(false);
        } else {
            this._internal.setEnabled(fd.canChangeVisibility());
            this._popup.setEnabled(fd.canChangePopup());
            this._readonly.setEnabled(fd.canChangeReadonly());
            this._internal.setSelected(fd.isInternal());
            this._readonly.setSelected(fd.isReadonly());
            this._popup.setSelected(fd.isPopup());
        }
    }

    private void initComponents() {
        this._toolbar = new JToolBar();
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(290, 380));
        this.setLayout(new BorderLayout());
        this._toolbar.setFloatable(false);
        this._toolbar.setRollover(true);
        this.add((Component)this._toolbar, "Last");
    }
}

