/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.nodes.TransformSetNode;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class AllSetsChildFactory
extends ChildFactory<TransformSet>
implements RepositoryListener {
    public AllSetsChildFactory() {
        TransformSetRepository registry = TransformSetRepository.getDefault();
        registry.addRepositoryListener((RepositoryListener)WeakListeners.create(RepositoryListener.class, (EventListener)((Object)this), (Object)registry));
    }

    protected boolean createKeys(List<TransformSet> toFill) {
        TransformSetRepository registry = TransformSetRepository.getDefault();
        toFill.addAll(registry.allSets());
        Collections.sort(toFill, new Comparator<TransformSet>(){

            @Override
            public int compare(TransformSet o1, TransformSet o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return true;
    }

    protected Node createNodeForKey(TransformSet key) {
        return new TransformSetNode(key);
    }

    protected Node createWaitNode() {
        AbstractNode wait = new AbstractNode(Children.LEAF);
        wait.setDisplayName("Loading...");
        return wait;
    }

    public void onItemAdded(RepositoryEvent evt) {
        this.refresh(false);
    }

    public void onItemChanged(RepositoryEvent evt) {
        this.refresh(false);
    }

    public void onItemRemoved(RepositoryEvent evt) {
        this.refresh(false);
    }
}

