/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.convert;

import com.paterva.maltego.typing.convert.DefaultStringConverter;
import com.paterva.maltego.typing.convert.StringConverter;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import org.openide.util.Exceptions;

public class ColorStringConverter
implements StringConverter {
    @Override
    public Object convertFrom(String value, Class to) throws IllegalArgumentException {
        Object result = null;
        if (!StringUtilities.isNullOrEmpty((String)value)) {
            try {
                result = Color.decode(value);
                if (result == null) {
                    result = DefaultStringConverter.instance().convertFrom(value, to);
                }
            }
            catch (NumberFormatException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                result = Color.BLACK;
            }
        }
        return result;
    }

    @Override
    public String convertTo(Object value, Class from) throws IllegalArgumentException {
        if (value instanceof Color) {
            Color c = (Color)value;
            return ColorUtilities.encode((Color)c);
        }
        return DefaultStringConverter.instance().convertTo(value, from);
    }
}

