/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.tools;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ValidationUtils {
    private static final Logger LOG = Logger.getLogger(ValidationUtils.class.getName());

    private static boolean cmp(Map uncollected, Map newUncollected) {
        if (uncollected.size() != newUncollected.size()) {
            return false;
        }
        for (Object object : uncollected.keySet()) {
            if (newUncollected.containsKey(object)) continue;
            return false;
        }
        return true;
    }

    public static void compare(InMemoryCollectionNodes collectionNodes, Map<EntityID, EntityLinks> uncollectedEnts, Map<LinkID, LinkEntityIDs> uncollectedLinks) throws GraphStoreException {
        Map<EntityID, ViewEntity> viewEntities = collectionNodes.getViewEntities();
        Map<LinkID, ViewLink> viewLinks = collectionNodes.getViewLinks();
        Set<EntityID> touchedViewEntities = viewEntities.keySet();
        Set<LinkID> touchedViewLinks = viewLinks.keySet();
        HashMap<EntityID, EntityLinks> newUncollectedEnts = new HashMap<EntityID, EntityLinks>();
        HashMap<LinkID, LinkEntityIDs> newUncollectedLinks = new HashMap<LinkID, LinkEntityIDs>();
        for (EntityID touchedViewEntity : touchedViewEntities) {
            ViewEntity ve = viewEntities.get(touchedViewEntity);
            if (ve.isCollection()) {
                for (EntityID entityID : ve.getCollection()) {
                    newUncollectedEnts.put(entityID, null);
                }
                continue;
            }
            EntityLinks allLinks = ve.getAllLinks();
            Set<LinkID> in = allLinks.getModelIncomingLinks();
            Set<LinkID> out = allLinks.getModelOutgoingLinks();
            EntityLinks el = new EntityLinks(in, out, in, out);
            newUncollectedEnts.put(touchedViewEntity, el);
        }
        for (LinkID touchedViewLink : touchedViewLinks) {
            ViewLink vl = viewLinks.get(touchedViewLink);
            if (vl.isCollection()) {
                for (LinkID linkID : vl.getCollection()) {
                    newUncollectedLinks.put(linkID, null);
                }
                continue;
            }
            newUncollectedLinks.put(touchedViewLink, vl.getEntities());
        }
        if (!ValidationUtils.cmp(uncollectedEnts, newUncollectedEnts)) {
            LOG.fine("Output entities do not match");
        }
        if (!ValidationUtils.cmp(uncollectedLinks, newUncollectedLinks)) {
            LOG.fine("Output links do not match");
        }
    }
}

