/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api.remote;

import com.maltego.tx3.java.api.discovery.V3SeedResponse;
import com.maltego.tx3.java.api.discovery.V3TransformApplication;
import com.maltego.tx3.java.api.discovery.V3Transforms;
import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.protocol.api.DiscoveryInfo;
import com.paterva.maltego.transform.protocol.api.ProxyException;
import com.paterva.maltego.transform.protocol.api.TransformApplicationDescriptor;
import com.paterva.maltego.transform.protocol.api.TransformFindException;
import com.paterva.maltego.transform.protocol.api.TransformListInfo;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformSource;
import com.paterva.maltego.transform.protocol.v3.api.proxy.V3HttpProxy;
import com.paterva.maltego.transform.protocol.v3.api.remote.RemoteTransformTranslator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class V3RemoteTransformSource
extends RemoteTransformSource {
    private static final Logger LOG = Logger.getLogger(V3RemoteTransformSource.class.getName());

    public TransformListInfo getTransforms(String sourceDescription, ProtocolVersion version) throws TransformFindException, CertificateNeedValidationException {
        try {
            V3HttpProxy proxy = this.getProxy(sourceDescription, version.toString());
            V3Transforms transformsDiscoveryResponse = proxy.listTransforms(true);
            try {
                TransformListInfo info = new TransformListInfo();
                RemoteTransformTranslator tt = new RemoteTransformTranslator();
                info.getTransforms().addAll(tt.translate(transformsDiscoveryResponse.getTransforms()));
                info.getOAuthAuthenticators().addAll(tt.translateOAuth(transformsDiscoveryResponse.getOauth()));
                return info;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                throw new TransformFindException("Invalid message format", ex);
            }
        }
        catch (ProxyException ex) {
            throw new TransformFindException("Failed to fetch transforms from url: " + sourceDescription, (Exception)((Object)ex));
        }
    }

    public DiscoveryInfo getDiscoveryInfo(String seedUrl, String sourceDescription, boolean httpsOnly, int timeout, ProtocolVersion version) throws TransformFindException, CertificateNeedValidationException {
        try {
            V3HttpProxy proxy = this.getProxy(sourceDescription, version.toString());
            V3SeedResponse seed = proxy.getDiscoveryInfo(httpsOnly);
            try {
                DiscoveryInfo discoveryInfo = new DiscoveryInfo(sourceDescription);
                for (V3TransformApplication transformApp : seed.getTransformApplications()) {
                    ProtocolVersion _version = version;
                    if (null != transformApp.getProtocolVersion()) {
                        try {
                            _version = ProtocolVersion.get((String)transformApp.getProtocolVersion());
                        }
                        catch (NumberFormatException ex) {
                            LOG.log(Level.FINEST, "Cannot parse protocol version: {0}", transformApp.getProtocolVersion());
                        }
                    }
                    TransformApplicationDescriptor appDescriptor = new TransformApplicationDescriptor(transformApp.getName(), transformApp.getUrl(), seedUrl, transformApp.getVersion(), transformApp.getDisclaimer(), _version);
                    appDescriptor.setRequiresKey(transformApp.isRequireApiKey());
                    appDescriptor.setOverwriteConfig(transformApp.isOverwriteConfig());
                    appDescriptor.setV3Url(transformApp.getV3Url());
                    discoveryInfo.getApplications().add(appDescriptor);
                }
                return discoveryInfo;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                throw new TransformFindException("Invalid message format", ex);
            }
        }
        catch (ProxyException ex) {
            throw new TransformFindException("Error during remote execution", (Exception)((Object)ex));
        }
    }

    private V3HttpProxy getProxy(String url, String protocolVersion) {
        return new V3HttpProxy(url, protocolVersion);
    }
}

