/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.maltego.tx3.java.api.execution.Entity;
import com.maltego.tx3.java.api.execution.Graph;
import com.maltego.tx3.java.api.execution.TransformRunChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunEntityEvent;
import com.maltego.tx3.java.api.execution.TransformRunEvent;
import com.maltego.tx3.java.api.execution.TransformRunExecutionContext;
import com.maltego.tx3.java.api.execution.TransformRunInputPromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunLinkEvent;
import com.maltego.tx3.java.api.execution.TransformRunMultiChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunPromptResponse;
import com.maltego.tx3.java.api.execution.TransformRunRequest;
import com.maltego.tx3.java.api.execution.TransformRunResponse;
import com.maltego.tx3.java.api.execution.TransformRunSetting;
import com.maltego.tx3.java.api.execution.TransformRunStatus;
import com.maltego.tx3.java.api.execution.TransformRunStatusMessageEvent;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.transform.descriptor.ConditionalInputConstraint;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.ExecutionInputConstraint;
import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformInputType;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.protocol.api.ProxyException;
import com.paterva.maltego.transform.protocol.v2api.api.CodedTransformRunException;
import com.paterva.maltego.transform.protocol.v3.api.CallbackV3;
import com.paterva.maltego.transform.protocol.v3.api.RemoteTransformRunnerV3;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultCache;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultPage;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultPageMergeResults;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultPageMerger;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultProcessor;
import com.paterva.maltego.transform.protocol.v3.api.V3MatchingRuleDescriptor;
import com.paterva.maltego.transform.protocol.v3.api.V3ProtocolTranslator;
import com.paterva.maltego.transform.protocol.v3.api.V3ProxyMessageTranslater;
import com.paterva.maltego.transform.protocol.v3.api.V3TransformTranslator;
import com.paterva.maltego.transform.protocol.v3.api.prompts.TransformPromptCallback;
import com.paterva.maltego.transform.protocol.v3.api.prompts.TransformPromptContext;
import com.paterva.maltego.transform.protocol.v3.api.proxy.V3HttpProxy;
import com.paterva.maltego.transform.protocol.v3.api.remote.RemoteTransformTranslator;
import com.paterva.maltego.transform.runner.api.AbstractTransformAdapter;
import com.paterva.maltego.transform.runner.api.TransformCallback;
import com.paterva.maltego.transform.runner.api.TransformDoneMutex;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.transform.runner.api.TransformRunRestrictedException;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.TraceContextId;
import com.pinkmatter.utils.time.HumanTime;
import java.net.MalformedURLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class RemoteTransformAdapterV3
extends AbstractTransformAdapter {
    private RemoteTransformRunnerV3 runner;
    private long _lastLicenseCheck = 0L;
    private static final int MIN_BETWEEN_CHECKS = 5;
    private static final int MS_BETWEEN_CHECKS = 300000;

    private V3HttpProxy getProxy(TransformRunContext ctx) throws TransformRunException {
        String target = ctx.getServerUrl().orElse(null);
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null");
        }
        TransformServerInfo server = ctx.getServer().orElse(null);
        String protocolVersion = ProtocolVersion.V3_1.toString();
        if (null != server && null != server.getProtocolVersion()) {
            protocolVersion = server.getProtocolVersion().toString();
        }
        V3HttpProxy proxy = new V3HttpProxy(target, protocolVersion);
        return proxy;
    }

    protected boolean applyAdvancedProperties() {
        return true;
    }

    protected List<Cancellable> runAsync(TransformRunContext ctx) throws TransformRunException, TransformRunRestrictedException {
        if (!this.validateLicense()) {
            throw new TransformRunException("Maltego needs to be activated before it can run transforms (alternatively please check your network and proxy settings).");
        }
        Args.notNull((Object)ctx, (String)"ctx");
        List<MaltegoEntity> inputEntities = ctx.getInputEntities().values().stream().collect(Collectors.toList());
        Constraint inputConstraint = ctx.getTransform().getInputConstraint();
        ArrayList<Cancellable> cancellables = new ArrayList<Cancellable>();
        if (!A.B()) {
            throw TransformRunRestrictedException.forRemote();
        }
        ResultHandler resultHandler = (ResultHandler)this.getDoneMutex();
        if (inputConstraint instanceof ConditionalInputConstraint && ((ConditionalInputConstraint)inputConstraint).getInputType().equals((Object)TransformInputType.GRAPH) || inputConstraint instanceof ExecutionInputConstraint && ((ExecutionInputConstraint)inputConstraint).getInputType().equals((Object)TransformInputType.GRAPH)) {
            Map links = ctx.getInputLinks();
            resultHandler.setTransformRunCount(1);
            this.runner = this.runner(inputEntities, links, ctx);
            cancellables.add(this.runner.run(resultHandler));
        } else if (inputConstraint instanceof ConditionalInputConstraint && ((ConditionalInputConstraint)inputConstraint).getInputType().equals((Object)TransformInputType.ENTITY) || inputConstraint instanceof ExecutionInputConstraint && ((ExecutionInputConstraint)inputConstraint).getInputType().equals((Object)TransformInputType.ENTITY)) {
            resultHandler.setTransformRunCount(ctx.getInputEntities().size());
            for (MaltegoEntity inputEntity : ctx.getInputEntities().values()) {
                this.runner = this.runner(Arrays.asList(inputEntity), Collections.EMPTY_MAP, ctx);
                cancellables.add(this.runner.run(resultHandler));
            }
        } else {
            resultHandler.setTransformRunCount(1);
            this.runner = this.runner(inputEntities, Collections.EMPTY_MAP, ctx);
            cancellables.add(this.runner.run(resultHandler));
        }
        return cancellables;
    }

    private boolean validateLicense() {
        long time = System.currentTimeMillis();
        long delta = time - this._lastLicenseCheck;
        if (delta > 300000L) {
            this._lastLicenseCheck = time;
            return LicenseManager.A().A(false, false);
        }
        return true;
    }

    protected RemoteTransformRunnerV3 runner(List<MaltegoEntity> maltegoEntities, Map<MaltegoLink, LinkEntityIDs> links, TransformRunContext ctx) throws TransformRunException {
        TransformRunRequest.RequestBuilder builder;
        Args.notNull(maltegoEntities, (String)"maltegoEntities");
        Args.notNull(links, (String)"links");
        Args.notNull((Object)ctx, (String)"ctx");
        TransformDefinition transform = ctx.getTransform();
        String transformId = V3TransformTranslator.getV2Name((String)transform.getName());
        if (!links.isEmpty()) {
            Graph graph = V3ProtocolTranslator.translate(maltegoEntities, links, ctx.getEntityRegistry());
            builder = TransformRunRequest.builder((Graph)graph);
        } else {
            List<Entity> entities = V3ProtocolTranslator.translate(maltegoEntities, ctx.getEntityRegistry());
            builder = TransformRunRequest.builder(entities);
        }
        List<TransformRunSetting> transformSettings = RemoteTransformTranslator.translate((TransformDescriptor)transform, ctx.getTransformInputs());
        builder.settings(transformSettings);
        builder.limits(this.getLimit(ctx.getTransformInputs()));
        String sourceName = ctx.getRunOrigin().getHashedOriginName();
        String graphId = ctx.getTransformsContext().getTargetGraphID().toString();
        builder.runContext(new TransformRunExecutionContext(graphId, TransformRunExecutionContext.RunSource.valueOf((String)ctx.getRunOrigin().getRunSource().name()), sourceName));
        return new RemoteTransformRunnerV3(transformId, this.getProxy(ctx), builder.build(), this.getKey(ctx));
    }

    private String getKey(TransformRunContext ctx) throws TransformRunException {
        String target = ((TransformServerInfo)ctx.getServer().orElseThrow(() -> new IllegalArgumentException("Server is null"))).getUrl().toString();
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        FastURL targetUrl = new FastURL(target);
        try {
            targetUrl.getURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        TransformServerInfo server = TransformServerRegistry.getDefault().get(targetUrl);
        if (server == null) {
            throw new TransformRunException("No server found for target " + target);
        }
        String key = server.getAuthentication().getToken(target);
        return key == null ? "" : key;
    }

    protected TransformDoneMutex createDoneMutex(TransformRunContext ctx) {
        Args.notNull((Object)ctx, (String)"ctx");
        return new ResultHandler(ctx);
    }

    private class ResultHandler
    extends TransformDoneMutex
    implements CallbackV3,
    TransformPromptCallback {
        private final TransformRunContext ctx;
        private final Instant transformStartTime;
        private int completeCount;
        private int transformRunCount;
        private int totalAddedEntityCount;
        private final int entityLimit;

        public ResultHandler(TransformRunContext ctx) {
            this.ctx = ctx;
            this.transformStartTime = Instant.now();
            com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
            this.entityLimit = licenseMode.Q() ? 12 : RemoteTransformAdapterV3.this.getLimit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resultReceived(TransformRunResponse response, TransformRunResultCache cache, String transformId, String runId, TraceContextId traceContextId) throws TypeInstantiationException {
            ResultHandler resultHandler = this;
            synchronized (resultHandler) {
                TransformRunResultProcessor processor = new TransformRunResultProcessor(this.ctx, transformId, runId);
                if (response.getResult() != null) {
                    List events = response.getResult().getEvents();
                    for (TransformRunEvent event : events) {
                        if (event.getData() == null) continue;
                        switch (event.getData().getInputType()) {
                            case ENTITY: {
                                processor.handle((TransformRunEntityEvent)event.getData());
                                break;
                            }
                            case LINK: {
                                processor.handle((TransformRunLinkEvent)event.getData());
                                break;
                            }
                            case STATUS_MESSAGE: {
                                processor.handle((TransformRunStatusMessageEvent)event.getData());
                                break;
                            }
                            case CHOICE_PROMPT: {
                                processor.handle((TransformRunChoicePromptEvent)event.getData(), (TransformPromptCallback)this, traceContextId);
                                break;
                            }
                            case MULTI_CHOICE_PROMPT: {
                                processor.handle((TransformRunMultiChoicePromptEvent)event.getData(), (TransformPromptCallback)this, traceContextId);
                                break;
                            }
                            case INPUT_PROMPT: {
                                processor.handle((TransformRunInputPromptEvent)event.getData(), (TransformPromptCallback)this, traceContextId);
                                break;
                            }
                        }
                    }
                }
                this.updateMatchingRule(processor.getAddedEntities());
                this.handleUiMessages(response.getStatus());
                TransformRunResultPage page = processor.done();
                TransformRunResultPageMerger merger = new TransformRunResultPageMerger(this.ctx, cache, RemoteTransformAdapterV3.this.getLimit());
                TransformRunResultPageMergeResults pageMergeResults = merger.mergeAndApply(page);
                this.handlePageMergeResults(pageMergeResults);
            }
        }

        void handlePageMergeResults(TransformRunResultPageMergeResults mergeResults) {
            String progressMsg = "Transform " + this.ctx.getTransform().getDisplayName() + " returned with " + mergeResults.getAddedEntitiesCount() + " entities.";
            TransformResult result = TransformResult.progress((String)progressMsg, (int)this.getProgressPercentage(), (GraphID)mergeResults.getGraphId(), (int)mergeResults.getAddedEntitiesCount(), (boolean)false, mergeResults.getInputToOutputEntities(), mergeResults.getRemovedEntities(), mergeResults.getRemovedLinks());
            this.ctx.getCallback().resultReceived(result);
        }

        protected void handleUiMessages(TransformRunStatus status) {
            List messages = status.getUiMessages();
            if (messages != null && !messages.isEmpty()) {
                List transformMessages = messages.stream().map(m -> V3ProxyMessageTranslater.translate(m, status.getCode())).collect(Collectors.toList());
                this.ctx.getCallback().resultReceived(TransformResult.messages(transformMessages));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exception(Exception ex, Instant completeTime) {
            ResultHandler resultHandler = this;
            synchronized (resultHandler) {
                Args.notNull((Object)ex, (String)"ex");
                TransformCallback cb = this.ctx.getCallback();
                String message = ex.getMessage();
                if (ex instanceof CodedTransformRunException) {
                    cb.resultReceived(TransformResult.error((String)message, (int)((CodedTransformRunException)ex).getCode()));
                } else {
                    String errMsg = "Transform " + this.ctx.getTransform().getDisplayName() + " returned with an error: " + message;
                    cb.resultReceived(TransformResult.error((String)errMsg));
                }
                this.completed(0, completeTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int addedEntityCount, Instant completeTime) {
            ResultHandler resultHandler = this;
            synchronized (resultHandler) {
                ++this.completeCount;
                this.totalAddedEntityCount += addedEntityCount;
                if (this.completeCount >= this.transformRunCount) {
                    String completedMessage = this.buildCompletedMessage(this.totalAddedEntityCount, completeTime);
                    this.ctx.getCallback().resultReceived(TransformResult.complete((String)completedMessage));
                    this.notify();
                }
            }
        }

        private String buildCompletedMessage(int addedEntityCount, Instant completeTime) {
            Duration executionTime = Duration.between(this.transformStartTime, completeTime);
            String displayName = this.ctx.getTransform().getDisplayName();
            String formatedExecutionTime = HumanTime.exactly((long)executionTime.toMillis());
            String message = "Transform " + displayName + " completed in " + formatedExecutionTime;
            if (addedEntityCount == 1) {
                message = message + " with " + addedEntityCount + " entity returned";
            } else if (addedEntityCount > 1) {
                message = message + " with " + addedEntityCount + " entities returned";
            }
            return message;
        }

        private int getProgressPercentage() {
            return Math.min(100 * this.completeCount / this.transformRunCount, 100);
        }

        @Override
        public boolean limitReached(int totalAddedEntityCount) {
            return totalAddedEntityCount >= this.entityLimit;
        }

        @Override
        public boolean isCancelled() {
            return this.ctx.getCallback().getIsCancelled();
        }

        public void setTransformRunCount(int transformRunCount) {
            this.transformRunCount = transformRunCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMatchingRule(Collection<Entity> entities) {
            TransformDefinition transform = this.ctx.getTransform();
            EntityRegistry entityRegistry = this.ctx.getEntityRegistry();
            TransformDefinition transformDefinition = transform;
            synchronized (transformDefinition) {
                V3MatchingRuleDescriptor rule;
                MatchingRuleDescriptor matchingRule = transform.getMatchingRule();
                if (matchingRule instanceof V3MatchingRuleDescriptor) {
                    rule = (V3MatchingRuleDescriptor)matchingRule;
                } else {
                    rule = new V3MatchingRuleDescriptor();
                    transform.setMatchingRule((MatchingRuleDescriptor)rule);
                }
                if (entities != null && !entities.isEmpty()) {
                    Set<String> types = entities.stream().map(Entity::getType).collect(Collectors.toSet());
                    rule.reset(types);
                }
                rule.update(entities, entityRegistry);
            }
        }

        @Override
        public void promptSelected(TransformRunPromptResponse response, TransformPromptContext context) {
            try {
                V3HttpProxy proxy = RemoteTransformAdapterV3.this.getProxy(this.ctx);
                String key = RemoteTransformAdapterV3.this.getKey(this.ctx);
                proxy.postPromptResponse(response, context.getPromptId(), context.getTransformId(), context.getRunId(), key, context.getTraceContextId());
            }
            catch (JsonProcessingException | ProxyException | TransformRunException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

