/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.serializer;

import com.maltego.cloud.serializer.NeoJsonAttachments;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.types.Attachments;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class NeoJsonAttachmentsFactory {
    public Map<Guid, NeoJsonAttachments> getAttachments(GraphID graphID) {
        LinkedHashMap<Guid, NeoJsonAttachments> attachments = new LinkedHashMap<Guid, NeoJsonAttachments>();
        AtomicInteger attsIndex = new AtomicInteger(0);
        Collection entities = GraphStoreHelper.getMaltegoEntitiesWithAttachments((GraphID)graphID);
        this.addAttachments(attachments, entities, attsIndex);
        return attachments;
    }

    private void addAttachments(Map<Guid, NeoJsonAttachments> attachments, Collection<? extends MaltegoPart> parts, AtomicInteger attsIndex) {
        for (MaltegoPart maltegoPart : parts) {
            Attachments atts = this.getFirstAttachments(maltegoPart);
            if (atts == null) continue;
            NeoJsonAttachments jsonAtts = new NeoJsonAttachments(maltegoPart, atts, attsIndex.get());
            attachments.put(maltegoPart.getID(), jsonAtts);
            attsIndex.addAndGet(atts.size());
        }
    }

    private Attachments getFirstAttachments(MaltegoPart part) {
        PropertyDescriptorCollection properties = part.getProperties();
        for (PropertyDescriptor pd : properties) {
            Object value;
            if (!Attachments.class.equals((Object)pd.getType()) || !((value = part.getValue(pd)) instanceof Attachments)) continue;
            return (Attachments)value;
        }
        return null;
    }
}

