/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.crypto;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.maltego.cloud.crypto.CloudGraphKeystore;
import com.maltego.cloud.crypto.Pair;
import com.maltego.cloud.crypto.util.CryptoUtilities;
import com.maltego.cloud.crypto.util.GMACUtil;
import com.maltego.cloud.crypto.util.JsonEncryptionUtil;
import com.maltego.cloud.data.CaseKey;
import com.maltego.cloud.data.GraphEncryptionConfig;
import com.maltego.cloud.data.GraphKey;
import com.maltego.cloud.data.MessageAuthenticationConfig;
import com.maltego.cloud.data.SymmetricEncryptionConfig;
import com.paterva.maltego.core.GraphID;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public class GraphEncryptor {
    private static final Logger LOG = Logger.getLogger(GraphEncryptor.class.getName());
    private CaseKey caseKeyMeta;
    private GraphKey graphKeyMeta;
    private SecretKey caseKey;
    private SecretKey graphKey;

    private GraphEncryptor() {
    }

    public static GraphEncryptor forExistingGraph(CaseKey caseKeyMeta, GraphKey graphKeyMeta) throws GeneralSecurityException, IOException {
        SecretKey caseKey = GraphEncryptor.extractCaseKey(caseKeyMeta);
        SecretKey graphKey = CryptoUtilities.decryptGraphKey(Base64.getDecoder().decode(graphKeyMeta.getEncryptedKey()), caseKey, Base64.getDecoder().decode(graphKeyMeta.getEncryptionConfig().getIv()));
        GraphEncryptor graphEncryptor = new GraphEncryptor();
        graphEncryptor.caseKeyMeta = caseKeyMeta;
        graphEncryptor.graphKeyMeta = graphKeyMeta;
        graphEncryptor.caseKey = caseKey;
        graphEncryptor.graphKey = graphKey;
        return graphEncryptor;
    }

    public static GraphEncryptor forNewGraph(CaseKey caseKeyMeta, GraphID graphID) throws GeneralSecurityException, IOException {
        SecretKey caseKey = GraphEncryptor.extractCaseKey(caseKeyMeta);
        SecretKey graphKey = CryptoUtilities.generateAESKey();
        byte[] graphKeyIV = CryptoUtilities.generateIV();
        byte[] encryptedGraphKey = CryptoUtilities.encryptGraphKey(graphKey, caseKey, graphKeyIV);
        byte[] tag = GMACUtil.sign(caseKey, graphKeyIV, graphKey.getEncoded());
        GraphKey graphKeyMeta = new GraphKey(graphID.toString(), caseKeyMeta.getId(), new SymmetricEncryptionConfig(Base64.getEncoder().encodeToString(graphKeyIV), Base64.getEncoder().encodeToString(tag), "AES256_GCM"), Base64.getEncoder().encodeToString(encryptedGraphKey));
        GraphEncryptor graphEncryptor = new GraphEncryptor();
        graphEncryptor.caseKeyMeta = caseKeyMeta;
        graphEncryptor.graphKeyMeta = graphKeyMeta;
        graphEncryptor.caseKey = caseKey;
        graphEncryptor.graphKey = graphKey;
        return graphEncryptor;
    }

    private static SecretKey extractCaseKey(CaseKey caseKeyMeta) throws GeneralSecurityException, IOException {
        CloudGraphKeystore keystore = CloudGraphKeystore.getDefault();
        PrivateKey privateKey = keystore.getPrivateKey();
        return CryptoUtilities.decryptCaseKey(Base64.getDecoder().decode(caseKeyMeta.getEncryptedKey()), privateKey);
    }

    public GraphKey getGraphKeyMeta() {
        return this.graphKeyMeta;
    }

    public Pair<String, String> encryptGraphJson(GraphEncryptionConfig encryptionConfig, String plainGraphJson) throws IOException, GeneralSecurityException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode data = (ObjectNode)mapper.readValue(plainGraphJson, ObjectNode.class);
        byte[] iv = Base64.getDecoder().decode(encryptionConfig.getBulkEncryptionConfig().getIv());
        List<String> atomicKeyPaths = encryptionConfig.getAtomicEncryptionPaths();
        List<String> bulkKeyPaths = encryptionConfig.getBulkEncryptionPaths();
        Pair<ObjectNode, byte[]> encryptedResult = JsonEncryptionUtil.encryptJson(data, this.graphKey, iv, bulkKeyPaths, atomicKeyPaths);
        byte[] tag = encryptedResult.second();
        String tagBase64 = Base64.getEncoder().encodeToString(tag);
        encryptionConfig.getBulkEncryptionConfig().setTag(tagBase64);
        ObjectNode encryptedGraph = encryptedResult.first();
        encryptedGraph.putPOJO("encryption", (Object)encryptionConfig);
        byte[] encryptedGraphBytes = mapper.writeValueAsBytes((Object)encryptedGraph);
        MessageAuthenticationConfig macConfig = this.signEncryptedGraphJson(encryptedGraphBytes);
        return new Pair<String, String>(new String(encryptedGraphBytes), mapper.writeValueAsString((Object)macConfig));
    }

    private MessageAuthenticationConfig signEncryptedGraphJson(byte[] encryptedGraphBytes) throws GeneralSecurityException {
        byte[] macIvBytes = CryptoUtilities.generateIV();
        byte[] macTagBytes = GMACUtil.sign(this.graphKey, macIvBytes, encryptedGraphBytes);
        byte[] gmacBytes = JsonEncryptionUtil.concatArrays(macIvBytes, macTagBytes);
        return new MessageAuthenticationConfig("GMAC", Base64.getEncoder().encodeToString(gmacBytes));
    }

    public byte[] encryptFileContent(GraphEncryptionConfig encryptionConfig, byte[] content) throws GeneralSecurityException {
        byte[] iv = Base64.getDecoder().decode(encryptionConfig.getBulkEncryptionConfig().getIv());
        return CryptoUtilities.encryptByteContent(content, this.graphKey, iv);
    }

    public String decryptGraphJson(GraphEncryptionConfig encryptionConfig, String encryptedGraphJson) throws IOException, GeneralSecurityException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode encryptedGraph = (ObjectNode)mapper.readValue(encryptedGraphJson, ObjectNode.class);
        byte[] iv = Base64.getDecoder().decode(encryptionConfig.getBulkEncryptionConfig().getIv());
        byte[] tag = Base64.getDecoder().decode(encryptionConfig.getBulkEncryptionConfig().getTag());
        List<String> atomicKeyPaths = encryptionConfig.getAtomicEncryptionPaths();
        List<String> bulkKeyPaths = encryptionConfig.getBulkEncryptionPaths();
        ObjectNode decryptedJson = JsonEncryptionUtil.decryptJson(encryptedGraph, bulkKeyPaths, atomicKeyPaths, this.graphKey, iv, tag);
        return mapper.writeValueAsString((Object)decryptedJson);
    }

    public void verifyEncryptedGraphJson(MessageAuthenticationConfig mac, String encryptedGraphJson) throws GeneralSecurityException {
        try {
            encryptedGraphJson = encryptedGraphJson.trim();
            byte[] macBytes = Base64.getDecoder().decode(mac.getCode());
            GMACUtil.verify(this.graphKey, macBytes, encryptedGraphJson.getBytes());
            LOG.info("Cloud graph is verified with Message Authentication Code");
        }
        catch (GeneralSecurityException e) {
            LOG.log(Level.WARNING, "Decrypted graph cannot be verified with Message Authentication Code");
            throw new GeneralSecurityException("Message Authentication Code verification failed!", e);
        }
    }

    public byte[] decryptFileContent(GraphEncryptionConfig encryptionConfig, byte[] encryptedContent) throws GeneralSecurityException {
        byte[] iv = Base64.getDecoder().decode(encryptionConfig.getBulkEncryptionConfig().getIv());
        return CryptoUtilities.decryptByteContent(encryptedContent, this.graphKey, iv);
    }
}

