/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.util.output.MessageLinkAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SelectLinksListener
extends MessageLinkAdapter {
    private final GraphChatRoom _graphChatRoom;
    private final Collection<LinkID> _linkIDs;

    public SelectLinksListener(GraphChatRoom graphChatRoom, Collection<LinkID> linkIDs) {
        this._graphChatRoom = graphChatRoom;
        this._linkIDs = linkIDs;
    }

    public Collection<LinkID> getLinkIDs() {
        return Collections.unmodifiableCollection(this._linkIDs);
    }

    public void linkAction() {
        GraphID graphID = this._graphChatRoom.getGraphID();
        this.selectLinks(graphID);
    }

    public String getTranslatorID() {
        return "lsel";
    }

    private void selectLinks(GraphID graphID) {
        HashSet existingLinkIDs = new HashSet(GraphStoreHelper.getLinkIDs((GraphID)graphID));
        existingLinkIDs.retainAll(this._linkIDs);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        selection.setSelectedModelLinks(existingLinkIDs);
    }
}

