/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout;

import com.paterva.maltego.ui.graph.view2d.layout.FastHierarchicLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.HorizontalAlignLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.VerticalAlignLayouter;
import java.util.logging.Level;
import java.util.logging.Logger;
import yguard.A.G.B.C;
import yguard.A.G.B.H;
import yguard.A.G.H.m;
import yguard.A.G.O.F;
import yguard.A.G.n;
import yguard.A.J.SA;

public class LayoutFactory {
    private static final Logger LOG = Logger.getLogger(LayoutFactory.class.getName());

    public static n getLayouter(SA graph, LayoutMode mode, boolean incremental) throws IllegalStateException {
        MaltegoLayouter layouter = null;
        switch (mode) {
            case BLOCK: {
                layouter = new MaltegoLayouter();
                break;
            }
            case HIERARCHICAL: {
                if (incremental) {
                    m ihl = new m();
                    ihl.n(60.0);
                    layouter = ihl;
                    break;
                }
                FastHierarchicLayouter hl = new FastHierarchicLayouter();
                hl.setMinimalFirstSegmentLength(60.0);
                layouter = hl;
                break;
            }
            case CIRCULAR: {
                int nodeCount = graph.v();
                int minimalEdgeLength = Math.max(40, nodeCount / 20);
                LOG.log(Level.FINE, "Nodes: {0} minimalEdgeLength: {1}", new Object[]{nodeCount, minimalEdgeLength});
                F circularLayouter = new F();
                circularLayouter.\u04c8().\u00c3(minimalEdgeLength);
                layouter = circularLayouter;
                break;
            }
            case ORGANIC: {
                layouter = new H();
                ((H)layouter).e(50.0);
                break;
            }
            case ALIGN_LEFT: {
                layouter = new VerticalAlignLayouter(0.0);
                break;
            }
            case ALIGN_RIGHT: {
                layouter = new VerticalAlignLayouter(1.0);
                break;
            }
            case ALIGN_TOP: {
                layouter = new HorizontalAlignLayouter(0.0);
                break;
            }
            case ALIGN_BOTTOM: {
                layouter = new HorizontalAlignLayouter(1.0);
                break;
            }
            case CENTER_VERTICALLY: {
                layouter = new VerticalAlignLayouter(0.5);
                break;
            }
            case CENTER_HORIZONTALLY: {
                layouter = new HorizontalAlignLayouter(0.5);
                break;
            }
            case INTERACTIVE_ORGANIC: {
                C ltr = new C();
                ltr.A(true);
                ltr.N();
                ltr.B(5000.0);
                layouter = ltr;
                break;
            }
            default: {
                throw new IllegalStateException("Layout mode invalid.");
            }
        }
        return layouter;
    }
}

