/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.StatusLineElementProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class StatusBar
extends JPanel
implements ChangeListener,
Runnable {
    private static final String TOP_GRADIENT1 = "status-bar-top-gradient1";
    private static final String DRAG_1 = "status-bar-drag-button-color1";
    private static final String DRAG_2 = "status-bar-drag-button-color2";
    private static final String FOREGROUND = "status-bar-fg";
    private static final int SURVIVING_TIME = Integer.getInteger("org.openide.awt.StatusDisplayer.DISPLAY_TIME", 5000);
    private static Lookup.Result<StatusLineElementProvider> result;
    private static JPanel innerIconsPanel;
    protected BufferedImage verticalImage;
    protected Object clearing;
    private final StatusDisplayer d = StatusDisplayer.getDefault();
    private final JLabel displayer;

    public StatusBar() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setPreferredSize(new Dimension(100, 20));
        this.setName("statusLine");
        this.displayer = new JLabel();
        this.add((Component)this.displayer, "Center");
        StatusBar.decoratePanel(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.run();
        this.d.addChangeListener((ChangeListener)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.d.removeChangeListener((ChangeListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        String currentMsg = this.d.getStatusText();
        Color fg = StatusBar.getColor(FOREGROUND);
        this.setForeground(fg);
        this.displayer.setForeground(fg);
        this.displayer.setText(currentMsg);
        if (SURVIVING_TIME != 0) {
            Object token;
            this.clearing = token = new Object();
            if (!"".equals(currentMsg)) {
                new Updater(token).schedule();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, super.getPreferredSize().height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, super.getMinimumSize().height);
    }

    static JPanel getStatusLineElements(JPanel panel) {
        Collection c;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(StatusLineElementProvider.class));
            result.addLookupListener((LookupListener)new StatusLineElementsListener(panel));
        }
        if ((c = result.allInstances()) == null || c.isEmpty()) {
            return null;
        }
        JPanel icons = new JPanel(new FlowLayout(2, 0, 0));
        icons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        icons.setOpaque(false);
        boolean some = false;
        for (StatusLineElementProvider o : c) {
            Component comp = o.getStatusLineElement();
            if (comp == null) continue;
            boolean mustAdd = true;
            if (comp instanceof JComponent) {
                ((JComponent)comp).setOpaque(false);
                if (comp instanceof JPanel) {
                    for (Component inner : ((JPanel)comp).getComponents()) {
                        if (inner == null || !inner.getClass().getName().toLowerCase().contains("crlfstatus")) continue;
                        mustAdd = false;
                    }
                }
            }
            StatusBar.setForeground(comp);
            if (!mustAdd) continue;
            some = true;
            icons.add(comp);
        }
        return some ? icons : null;
    }

    protected static void setForeground(Component comp) {
        if (comp != null) {
            comp.setForeground(StatusBar.getColor(FOREGROUND));
        }
        if (comp instanceof Container) {
            for (Component child : ((Container)comp).getComponents()) {
                StatusBar.setForeground(child);
            }
        }
    }

    private static void decoratePanel(JPanel panel) {
        if (innerIconsPanel != null) {
            panel.remove(innerIconsPanel);
        }
        if ((innerIconsPanel = StatusBar.getStatusLineElements(panel)) != null) {
            panel.add((Component)innerIconsPanel, "East");
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintChildren(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(StatusBar.getColor(TOP_GRADIENT1));
        g2d.fillRect(0, 0, this.getWidth(), 20);
    }

    private void drawDragButton(Graphics2D g2d) {
        g2d.translate(this.getWidth() - 11, this.getHeight() - 11);
        g2d.setColor(StatusBar.getColor(DRAG_2));
        g2d.drawRect(9, 9, 1, 1);
        g2d.drawRect(5, 9, 1, 1);
        g2d.drawRect(1, 9, 1, 1);
        g2d.drawRect(9, 5, 1, 1);
        g2d.drawRect(5, 5, 1, 1);
        g2d.drawRect(9, 1, 1, 1);
        g2d.setColor(StatusBar.getColor(DRAG_1));
        g2d.drawRect(8, 8, 1, 1);
        g2d.drawRect(4, 8, 1, 1);
        g2d.drawRect(0, 8, 1, 1);
        g2d.drawRect(8, 4, 1, 1);
        g2d.drawRect(4, 4, 1, 1);
        g2d.drawRect(8, 0, 1, 1);
        g2d.translate(-this.getWidth() + 11, -this.getHeight() + 11);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Font f = UIManager.getFont("controlFont");
        if (f == null) {
            f = UIManager.getFont("Tree.font");
        }
        if (f != null) {
            this.setFont(f);
        }
    }

    private static Color getColor(String key) {
        return UIManager.getLookAndFeelDefaults().getColor(key);
    }

    private class Updater
    implements ActionListener {
        private final Object token;
        private long startTime;
        private Timer controller;

        public Updater(Object token) {
            this.token = token;
        }

        public void schedule() {
            this.controller = new Timer(SURVIVING_TIME, this);
            this.controller.setDelay(100);
            this.controller.start();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (StatusBar.this.clearing == this.token) {
                long t = System.currentTimeMillis();
                if (this.startTime != 0L) {
                    Color c = StatusBar.getColor(StatusBar.FOREGROUND);
                    if (c != null) {
                        int alpha = 256 * (int)(t - this.startTime) / 2000;
                        Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - Math.min(255, alpha));
                        StatusBar.this.displayer.setForeground(color);
                    }
                } else {
                    this.startTime = t;
                }
                if (t > this.startTime + 2000L) {
                    this.controller.stop();
                }
            } else {
                this.controller.stop();
            }
        }
    }

    private static class StatusLineElementsListener
    implements LookupListener {
        private JPanel decoratingPanel;

        StatusLineElementsListener(JPanel decoratingPanel) {
            this.decoratingPanel = decoratingPanel;
        }

        public void resultChanged(LookupEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.decoratePanel(decoratingPanel);
                }
            });
        }
    }
}

