/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.maltego.tx3.java.api.discovery.MachineDefinition;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.imex.MachineDiscoveryProviderDelegate;
import com.paterva.maltego.automation.imex.MachineSerializer;
import com.paterva.maltego.automation.imex.MachinesDiscoveryItems;
import com.paterva.maltego.discovery.DiscoveryContext;
import com.paterva.maltego.discovery.DiscoveryProvider;
import com.paterva.maltego.json.discovery.JsonDiscoveryContext;
import com.paterva.maltego.json.discovery.JsonDiscoveryProvider;
import com.paterva.maltego.transform.protocol.v3.api.proxy.V3HttpProxy;
import java.util.ArrayList;
import java.util.List;

public class MachineJsonDiscoveryProvider
extends JsonDiscoveryProvider<MachinesDiscoveryItems>
implements DiscoveryProvider<MachinesDiscoveryItems> {
    private final MachineDiscoveryProviderDelegate delegate = new MachineDiscoveryProviderDelegate(this);

    public MachinesDiscoveryItems fetch(JsonDiscoveryContext dc) {
        V3HttpProxy proxy = new V3HttpProxy(dc.getV3Url());
        List machines = proxy.listMachines(true);
        ArrayList<MachineDescriptor> descriptors = new ArrayList<MachineDescriptor>();
        for (MachineDefinition machine : machines) {
            boolean enabled = true;
            if (machine.getEnabled() != null) {
                enabled = machine.getEnabled();
            }
            boolean isFavorite = false;
            if (machine.getFavorite() != null) {
                isFavorite = machine.getFavorite();
            }
            boolean readOnly = false;
            if (machine.getReadOnly() != null) {
                readOnly = machine.getReadOnly();
            }
            descriptors.add(MachineSerializer.read(machine.getCode(), isFavorite, enabled, readOnly));
        }
        return new MachinesDiscoveryItems(this, descriptors, (DiscoveryContext)dc);
    }

    public MachinesDiscoveryItems getNewAndMerged(MachinesDiscoveryItems items) {
        return this.delegate.getNewAndMerged(items);
    }

    public void apply(MachinesDiscoveryItems machines) {
        this.delegate.apply(machines);
    }

    public void cleanup() {
        this.delegate.cleanup();
    }
}

