/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.actions.AbstractAction;
import com.paterva.maltego.automation.actions.GraphHelper;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Exceptions;

public class RootAncestorsFilter
extends AbstractAction {
    public RootAncestorsFilter() {
        this("rootAncestors");
    }

    protected RootAncestorsFilter(String name) {
        super(name);
    }

    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        GraphID graphID = ctx.getTargetGraphID();
        HashSet<EntityID> rootIDs = new HashSet<EntityID>();
        try {
            for (EntityID entityID : payload.getEntityIDs()) {
                GraphHelper.getRootParents(entityID, graphID, rootIDs);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Set roots = GraphStoreHelper.getMaltegoEntities((GraphID)graphID, rootIDs);
        cb.completed(Payloads.fromEntities(roots));
    }
}

