/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui;

import com.paterva.maltego.seeds.api.HubSeedTag;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import org.openide.util.NbPreferences;

public class HubFilterManager {
    public static final String FILTERS_CLEARED = "filtersCleared";
    public static final String FILTER_SELECTION_CHANGED = "filterSelected";
    private static final Logger LOG = Logger.getLogger(HubFilterManager.class.getName());
    private static final String PREF_FILTERS = "maltego.hub.filters.selected";
    private static final HubFilterManager INSTANCE = new HubFilterManager();
    private final Preferences prefs = NbPreferences.forModule(this.getClass());
    private final List<HubSeedTag> selected = new LinkedList<HubSeedTag>();
    private final List<PropertyChangeListener> listeners = new LinkedList<PropertyChangeListener>();

    public HubFilterManager() {
        this.load();
    }

    public static HubFilterManager getInstance() {
        return INSTANCE;
    }

    public void clear() {
        this.selected.clear();
        this.save();
        this.fireChanged(FILTERS_CLEARED);
    }

    public Map<String, List<HubSeedTag>> getSelectedMap() {
        return this.selected.stream().collect(Collectors.groupingBy(t -> t.getType()));
    }

    public boolean anySelected() {
        return !this.selected.isEmpty();
    }

    public boolean anySelected(String tagType) {
        return this.selected.stream().anyMatch(t -> Objects.equals(tagType, t.getType()));
    }

    public boolean isSelected(String tagType, String tag) {
        return this.selected.stream().anyMatch(t -> this.isMatch((HubSeedTag)t, tagType, tag));
    }

    public void setSelected(String tagType, List<String> tags, boolean select) {
        tags.forEach(tag -> this.setSelectedInternal(tagType, (String)tag, select));
        this.save();
        this.fireChanged(FILTER_SELECTION_CHANGED);
    }

    public void setSelected(String tagType, String tag, boolean select) {
        this.setSelectedInternal(tagType, tag, select);
        this.save();
        this.fireChanged(FILTER_SELECTION_CHANGED);
    }

    private void setSelectedInternal(String tagType, String tag, boolean select) {
        if (select) {
            if (this.isSelected(tagType, tag)) {
                LOG.log(Level.FINE, "Tag already selected: {0}->{1}", new Object[]{tagType, tag});
            } else {
                LOG.log(Level.FINE, "Tag selected: {0}->{1}", new Object[]{tagType, tag});
                this.selected.add(new HubSeedTag(tagType, tag));
            }
        } else {
            Iterator<HubSeedTag> itr = this.selected.iterator();
            while (itr.hasNext()) {
                HubSeedTag hubSeedTag = itr.next();
                if (!this.isMatch(hubSeedTag, tagType, tag)) continue;
                LOG.log(Level.FINE, "Tag unselected: {0}->{1}", new Object[]{tagType, tag});
                itr.remove();
            }
        }
    }

    public void addChangeListener(PropertyChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(PropertyChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private boolean isMatch(HubSeedTag hubSeedTag, String tagType, String tag) {
        return Objects.equals(tagType, hubSeedTag.getType()) && Objects.equals(tag, hubSeedTag.getValue());
    }

    private void load() {
        this.selected.clear();
        String selectedFilters = this.prefs.get(PREF_FILTERS, "");
        if (!selectedFilters.isEmpty()) {
            String[] typeAndTags;
            for (String typeAndTag : typeAndTags = selectedFilters.split("\u0277")) {
                String[] tokens = typeAndTag.split("\u0278");
                if (tokens.length != 2) continue;
                this.selected.add(new HubSeedTag(tokens[0], tokens[1]));
            }
        }
    }

    private void save() {
        String selectedFilters = this.selected.stream().map(t -> t.getType() + "\u0278" + t.getValue()).collect(Collectors.joining("\u0277"));
        this.prefs.put(PREF_FILTERS, selectedFilters);
    }

    private void fireChanged(String property) {
        this.listeners.forEach(listener -> listener.propertyChange(new PropertyChangeEvent(this, property, null, null)));
    }
}

