/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.ArtifactDataConverter;
import com.pinkmatter.pandora.lucene.serialize.BigIntegerConverter;
import com.pinkmatter.pandora.lucene.serialize.BlobConverter;
import com.pinkmatter.pandora.lucene.serialize.BooleanConverter;
import com.pinkmatter.pandora.lucene.serialize.DateConverter;
import com.pinkmatter.pandora.lucene.serialize.DateRangeConverter;
import com.pinkmatter.pandora.lucene.serialize.DoubleConverter;
import com.pinkmatter.pandora.lucene.serialize.FloatConverter;
import com.pinkmatter.pandora.lucene.serialize.GeographyConverter;
import com.pinkmatter.pandora.lucene.serialize.GridPositionConverter;
import com.pinkmatter.pandora.lucene.serialize.IntConverter;
import com.pinkmatter.pandora.lucene.serialize.LongConverter;
import com.pinkmatter.pandora.lucene.serialize.MapConverter;
import com.pinkmatter.pandora.lucene.serialize.PairConverter;
import com.pinkmatter.pandora.lucene.serialize.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TypeConverter {
    protected static final String SEPARATOR = "|";
    protected static final String TYPE_START = "[";
    protected static final String TYPE_END = "]";
    protected static final String NOT_STORED = "*";
    protected static final String[] RESERVED = new String[]{".", "|", "[", "]", "*"};
    private static final Logger LOG = LoggerFactory.getLogger(TypeConverter.class);
    private static final List<TypeConverter> _converters = new ArrayList<TypeConverter>();
    private static final Map<String, TypeConverter> _fieldCache = new HashMap<String, TypeConverter>();
    private static final Map<Class, TypeConverter> _classCache = new HashMap<Class, TypeConverter>();

    public abstract String getType();

    public abstract Class getClassType();

    public abstract boolean isApplicable(Object var1);

    public abstract boolean isApplicable(Class var1);

    public abstract boolean isApplicable(String var1);

    public abstract String getProperty(String var1);

    abstract String getIndexField(String var1);

    public abstract void write(Object var1, String var2, Document var3) throws PandoraException;

    public abstract Object read(List<IndexableField> var1) throws PandoraException;

    public abstract Object read(List<IndexableField> var1, String var2) throws PandoraException;

    public abstract Query createFilter(PandoraFilter.Simple var1) throws PandoraException;

    public abstract SortField[] getSortFields(String var1, boolean var2, boolean var3);

    public static TypeConverter get(String field) {
        TypeConverter cc = _fieldCache.get(field);
        if (cc != null) {
            return cc;
        }
        for (TypeConverter c : _converters) {
            if (!c.isApplicable(field)) continue;
            _fieldCache.put(field, c);
            return c;
        }
        LOG.warn("Could not find a TypeConverter for field: {}", (Object)field);
        return null;
    }

    public static TypeConverter get(Object type) {
        Class<?> clazz = type.getClass();
        TypeConverter cc = _classCache.get(clazz);
        if (cc != null) {
            return cc;
        }
        for (TypeConverter c : _converters) {
            if (!c.isApplicable(type)) continue;
            if (clazz != Object.class && clazz != Object[].class) {
                _classCache.put(clazz, c);
            }
            return c;
        }
        LOG.warn("Could not find a TypeConverter for object: {}", type);
        return null;
    }

    public static TypeConverter get(Class type) {
        TypeConverter cc = _classCache.get(type);
        if (cc != null) {
            return cc;
        }
        for (TypeConverter c : _converters) {
            if (!c.isApplicable(type)) continue;
            if (type != Object.class && type != Object[].class) {
                _classCache.put(type, c);
            }
            return c;
        }
        LOG.warn("Could not find a TypeConverter for type: {}", (Object)type);
        return null;
    }

    public static Query getFilter(Class fieldType, PandoraFilter.Simple filter) throws PandoraException {
        TypeConverter c = TypeConverter.get(fieldType);
        if (c == null) {
            LOG.warn("Could not find a TypeConverter for field type: {} and filter: {}", (Object)fieldType, (Object)filter);
            return null;
        }
        return c.createFilter(filter);
    }

    public static SortField[] getSortFields(Class type, String field, boolean reverse, boolean emptyFirst) {
        TypeConverter c = TypeConverter.get(type);
        if (c == null) {
            LOG.warn("Could not find a TypeConverter for field type: {}", (Object)field);
            return null;
        }
        return c.getSortFields(field, reverse, emptyFirst);
    }

    public static void register(TypeConverter converter) {
        if (!_converters.contains(converter)) {
            LOG.info("Registering type converter: {}", (Object)converter);
            _converters.add(converter);
        }
    }

    public static boolean isStored(String field) {
        return !field.contains(NOT_STORED);
    }

    public static boolean isValidPropertyName(String property) {
        for (String res : RESERVED) {
            if (!property.contains(res)) continue;
            return false;
        }
        return true;
    }

    public static void assertValidPropertyName(String property) throws PandoraException {
        if (!TypeConverter.isValidPropertyName(property)) {
            throw new PandoraException(String.format("Invalid property name %s. These characters are not allowed: %s", property, Arrays.toString(RESERVED)));
        }
    }

    static {
        TypeConverter.register(new StringConverter());
        TypeConverter.register(new IntConverter());
        TypeConverter.register(new LongConverter());
        TypeConverter.register(new DoubleConverter());
        TypeConverter.register(new FloatConverter());
        TypeConverter.register(new DateConverter());
        TypeConverter.register(new DateRangeConverter());
        TypeConverter.register(new BooleanConverter());
        TypeConverter.register(new GeographyConverter());
        TypeConverter.register(new PairConverter());
        TypeConverter.register(new GridPositionConverter());
        TypeConverter.register(new ArtifactDataConverter());
        TypeConverter.register(new BlobConverter());
        TypeConverter.register(new MapConverter());
        TypeConverter.register(new BigIntegerConverter());
    }
}

