/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.PrimitiveTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.SortHelper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

class BooleanConverter
extends PrimitiveTypeConverter<Boolean> {
    protected static final String TRUE = "t";
    protected static final String FALSE = "f";
    private static final String DEPRECATED_TRUE = "true";
    private static final String DEPRECATED_FALSE = "false";

    public BooleanConverter() {
        super("bool", Boolean.class, Boolean.TYPE);
    }

    @Override
    protected void writeImpl(Boolean value, String field, Document to) {
        String fieldName = this.getIndexField(field);
        String storedValue = value != false ? TRUE : FALSE;
        to.add((IndexableField)new StringField(fieldName, storedValue, Field.Store.YES));
        to.add(SortHelper.createStringDocValueField(fieldName, storedValue));
    }

    @Override
    protected Boolean readImpl(IndexableField field) throws PandoraException {
        return field.stringValue().equals(TRUE) || field.stringValue().equals(DEPRECATED_TRUE);
    }

    @Override
    public SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        return new SortField[]{SortHelper.createStringSortField(this.getIndexField(property), reverse, emptyFirst)};
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) {
        if (Boolean.class.isAssignableFrom(parameters.getType())) {
            if (!(parameters instanceof PandoraFilter.Contains)) {
                return null;
            }
            PandoraFilter.Contains params = (PandoraFilter.Contains)parameters;
            PandoraFilter.Contains filter = new PandoraFilter.Contains(params.getProperty(), (Object[])new String[]{this.get((Boolean)params.getValue())});
            String field = this.getIndexField(parameters.getProperty());
            return FilterHelper.createSimpleQuery(field, filter);
        }
        return null;
    }

    private String get(Boolean b) {
        return b != false ? TRUE : FALSE;
    }

    private String[] get(Boolean[] b) {
        String[] strings = new String[b.length];
        for (int i = 0; i < b.length; ++i) {
            strings[i] = this.get(b[i]);
        }
        return strings;
    }
}

