/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.style.RenderState;

public class ColorFactory {
    private static final Logger logger = Logger.getLogger(ColorFactory.class.getName());
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    protected static final Color DEFAULT_SELECTION_COLOR = Color.BLUE;
    private static ColorFactory instance;
    private final Map colorMap = new HashMap(256);
    private Color bgColor = null;
    private static final String RGB_START = "rgb(";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorFactory() {
        Map colorMap = this.colorMap;
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            colorMap.put("transparent", TRANSPARENT);
            colorMap.put("aliceblue", new Color(0xF0F8FF));
            colorMap.put("antiquewhite", new Color(16444375));
            colorMap.put("aqua", new Color(65535));
            colorMap.put("aquamarine", new Color(8388564));
            colorMap.put("azure", new Color(0xF0FFFF));
            colorMap.put("beige", new Color(16119260));
            colorMap.put("bisque", new Color(16770244));
            colorMap.put("black", new Color(0));
            colorMap.put("blanchedalmond", new Color(16772045));
            colorMap.put("blue", new Color(255));
            colorMap.put("blueviolet", new Color(9055202));
            colorMap.put("brown", new Color(0xA52A2A));
            colorMap.put("burlywood", new Color(14596231));
            colorMap.put("cadetblue", new Color(6266528));
            colorMap.put("chartreuse", new Color(0x7FFF00));
            colorMap.put("chocolate", new Color(13789470));
            colorMap.put("coral", new Color(16744272));
            colorMap.put("cornflowerblue", new Color(6591981));
            colorMap.put("cornsilk", new Color(16775388));
            colorMap.put("crimson", new Color(14423100));
            colorMap.put("cyan", new Color(65535));
            colorMap.put("darkblue", new Color(139));
            colorMap.put("darkcyan", new Color(35723));
            colorMap.put("darkgoldenrod", new Color(12092939));
            colorMap.put("darkgray", new Color(0xA9A9A9));
            colorMap.put("darkgrey", new Color(0xA9A9A9));
            colorMap.put("darkgreen", new Color(25600));
            colorMap.put("darkkhaki", new Color(12433259));
            colorMap.put("darkmagenta", new Color(0x8B008B));
            colorMap.put("darkolivegreen", new Color(5597999));
            colorMap.put("darkorange", new Color(16747520));
            colorMap.put("darkorchid", new Color(10040012));
            colorMap.put("darkred", new Color(0x8B0000));
            colorMap.put("darksalmon", new Color(15308410));
            colorMap.put("darkseagreen", new Color(9419919));
            colorMap.put("darkslateblue", new Color(4734347));
            colorMap.put("darkslategray", new Color(0x2F4F4F));
            colorMap.put("darkslategrey", new Color(0x2F4F4F));
            colorMap.put("darkturquoise", new Color(52945));
            colorMap.put("darkviolet", new Color(9699539));
            colorMap.put("deeppink", new Color(16716947));
            colorMap.put("deepskyblue", new Color(49151));
            colorMap.put("dimgray", new Color(0x696969));
            colorMap.put("dimgrey", new Color(0x696969));
            colorMap.put("dodgerblue", new Color(2003199));
            colorMap.put("firebrick", new Color(0xB22222));
            colorMap.put("floralwhite", new Color(0xFFFAF0));
            colorMap.put("forestgreen", new Color(0x228B22));
            colorMap.put("fuchsia", new Color(0xFF00FF));
            colorMap.put("gainsboro", new Color(0xDCDCDC));
            colorMap.put("ghostwhite", new Color(0xF8F8FF));
            colorMap.put("gold", new Color(16766720));
            colorMap.put("goldenrod", new Color(14329120));
            colorMap.put("gray", new Color(0x808080));
            colorMap.put("grey", new Color(0x808080));
            colorMap.put("green", new Color(32768));
            colorMap.put("greenyellow", new Color(11403055));
            colorMap.put("honeydew", new Color(0xF0FFF0));
            colorMap.put("hotpink", new Color(16738740));
            colorMap.put("indianred", new Color(0xCD5C5C));
            colorMap.put("indigo", new Color(4915330));
            colorMap.put("ivory", new Color(0xFFFFF0));
            colorMap.put("khaki", new Color(15787660));
            colorMap.put("lavender", new Color(15132410));
            colorMap.put("lavenderblush", new Color(0xFFF0F5));
            colorMap.put("lawngreen", new Color(8190976));
            colorMap.put("lemonchiffon", new Color(16775885));
            colorMap.put("lightblue", new Color(11393254));
            colorMap.put("lightcoral", new Color(0xF08080));
            colorMap.put("lightcyan", new Color(0xE0FFFF));
            colorMap.put("lightgoldenrodyellow", new Color(16448210));
            colorMap.put("lightgray", new Color(0xD3D3D3));
            colorMap.put("lightgrey", new Color(0xD3D3D3));
            colorMap.put("lightgreen", new Color(0x90EE90));
            colorMap.put("lightpink", new Color(16758465));
            colorMap.put("lightsalmon", new Color(16752762));
            colorMap.put("lightseagreen", new Color(2142890));
            colorMap.put("lightskyblue", new Color(8900346));
            colorMap.put("lightslategray", new Color(0x778899));
            colorMap.put("lightslategrey", new Color(0x778899));
            colorMap.put("lightsteelblue", new Color(11584734));
            colorMap.put("lightyellow", new Color(0xFFFFE0));
            colorMap.put("lime", new Color(65280));
            colorMap.put("limegreen", new Color(3329330));
            colorMap.put("linen", new Color(16445670));
            colorMap.put("magenta", new Color(0xFF00FF));
            colorMap.put("maroon", new Color(0x800000));
            colorMap.put("mediumaquamarine", new Color(6737322));
            colorMap.put("mediumblue", new Color(205));
            colorMap.put("mediumorchid", new Color(12211667));
            colorMap.put("mediumpurple", new Color(9662680));
            colorMap.put("mediumseagreen", new Color(3978097));
            colorMap.put("mediumslateblue", new Color(8087790));
            colorMap.put("mediumspringgreen", new Color(64154));
            colorMap.put("mediumturquoise", new Color(4772300));
            colorMap.put("mediumvioletred", new Color(13047173));
            colorMap.put("midnightblue", new Color(1644912));
            colorMap.put("mintcream", new Color(0xF5FFFA));
            colorMap.put("mistyrose", new Color(16770273));
            colorMap.put("moccasin", new Color(16770229));
            colorMap.put("navajowhite", new Color(16768685));
            colorMap.put("navy", new Color(128));
            colorMap.put("oldlace", new Color(16643558));
            colorMap.put("olive", new Color(0x808000));
            colorMap.put("olivedrab", new Color(7048739));
            colorMap.put("orange", new Color(16753920));
            colorMap.put("orangered", new Color(16729344));
            colorMap.put("orchid", new Color(14315734));
            colorMap.put("palegoldenrod", new Color(0xEEE8AA));
            colorMap.put("palegreen", new Color(10025880));
            colorMap.put("paleturquoise", new Color(0xAFEEEE));
            colorMap.put("palevioletred", new Color(14184595));
            colorMap.put("papayawhip", new Color(16773077));
            colorMap.put("peachpuff", new Color(16767673));
            colorMap.put("peru", new Color(13468991));
            colorMap.put("pink", new Color(16761035));
            colorMap.put("plum", new Color(0xDDA0DD));
            colorMap.put("powderblue", new Color(11591910));
            colorMap.put("purple", new Color(0x800080));
            colorMap.put("red", new Color(0xFF0000));
            colorMap.put("rosybrown", new Color(12357519));
            colorMap.put("royalblue", new Color(4286945));
            colorMap.put("saddlebrown", new Color(9127187));
            colorMap.put("salmon", new Color(16416882));
            colorMap.put("sandybrown", new Color(16032864));
            colorMap.put("seagreen", new Color(3050327));
            colorMap.put("seashell", new Color(0xFFF5EE));
            colorMap.put("sienna", new Color(10506797));
            colorMap.put("silver", new Color(0xC0C0C0));
            colorMap.put("skyblue", new Color(8900331));
            colorMap.put("slateblue", new Color(6970061));
            colorMap.put("slategray", new Color(7372944));
            colorMap.put("slategrey", new Color(7372944));
            colorMap.put("snow", new Color(0xFFFAFA));
            colorMap.put("springgreen", new Color(65407));
            colorMap.put("steelblue", new Color(4620980));
            colorMap.put("tan", new Color(13808780));
            colorMap.put("teal", new Color(32896));
            colorMap.put("thistle", new Color(14204888));
            colorMap.put("tomato", new Color(16737095));
            colorMap.put("turquoise", new Color(4251856));
            colorMap.put("violet", new Color(0xEE82EE));
            colorMap.put("wheat", new Color(16113331));
            colorMap.put("white", new Color(0xFFFFFF));
            colorMap.put("whitesmoke", new Color(0xF5F5F5));
            colorMap.put("yellow", new Color(0xFFFF00));
            colorMap.put("yellowgreen", new Color(10145074));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ColorFactory getInstance() {
        if (instance != null) return instance;
        Class<ColorFactory> clazz = ColorFactory.class;
        synchronized (ColorFactory.class) {
            if (instance != null) return instance;
            instance = new ColorFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setBackgroundColor(Color color) {
        if (color != null && (this.bgColor == null || this.bgColor.equals(DEFAULT_BACKGROUND_COLOR))) {
            this.bgColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColor(String colorSpec) {
        if (colorSpec.startsWith("#")) {
            return true;
        }
        String normalSpec = colorSpec.toLowerCase();
        if (normalSpec.startsWith(RGB_START)) {
            return true;
        }
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            return this.colorMap.containsKey(normalSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor(String colorSpec) {
        String normalSpec = colorSpec.toLowerCase();
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            Color color = (Color)this.colorMap.get(normalSpec);
            if (color == null) {
                if (normalSpec.startsWith(RGB_START)) {
                    int endIdx = normalSpec.lastIndexOf(41);
                    String commaValues = endIdx == -1 ? normalSpec.substring(RGB_START.length()) : normalSpec.substring(RGB_START.length(), endIdx);
                    StringTokenizer tok = new StringTokenizer(commaValues, ",");
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    if (tok.hasMoreTokens()) {
                        String rstr = tok.nextToken().trim();
                        try {
                            r = Integer.parseInt(rstr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (tok.hasMoreTokens()) {
                            String gstr = tok.nextToken().trim();
                            try {
                                g = Integer.parseInt(gstr);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (tok.hasMoreTokens()) {
                                String bstr = tok.nextToken().trim();
                                try {
                                    b = Integer.parseInt(bstr);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    color = new Color(r, g, b);
                } else if (normalSpec.startsWith("#")) {
                    int len = normalSpec.length();
                    int[] rgba = new int[4];
                    rgba[3] = 255;
                    for (int i = 0; i < rgba.length; ++i) {
                        int idx = 2 * i + 1;
                        if (idx >= len) continue;
                        String hexText = normalSpec.substring(idx, idx + Math.min(2, len - idx));
                        try {
                            rgba[i] = Integer.parseInt(hexText, 16);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
                } else {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.warning("getColor(): Color spec [" + normalSpec + "] unknown.");
                    }
                    return Color.RED;
                }
                this.colorMap.put(normalSpec, color);
            }
            return color;
        }
    }

    public static String getColorTone(Color color) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return ColorFactory.getColorTone(hsb);
    }

    public static String getColorTone(int rgb) {
        float[] hsb = new float[3];
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        Color.RGBtoHSB(r, g, b, hsb);
        return ColorFactory.getColorTone(hsb);
    }

    public static String getColorTone(float[] hsb) {
        float deg;
        String colorTone = (double)hsb[1] < 0.1 && (double)hsb[2] > 0.9 ? "nearlyWhite" : ((double)hsb[2] < 0.1 ? "nearlyBlack" : ((deg = hsb[0] * 360.0f) >= 0.0f && deg < 30.0f ? "red" : (deg >= 30.0f && deg < 90.0f ? "yellow" : (deg >= 90.0f && deg < 150.0f ? "green" : (deg >= 150.0f && deg < 210.0f ? "cyan" : (deg >= 210.0f && deg < 270.0f ? "blue" : (deg >= 270.0f && deg < 330.0f ? "magenta" : "red")))))));
        return colorTone;
    }

    public static Color getXorColor(Color c1, Color c2) {
        int[] c1Array = new int[3];
        int[] c2Array = new int[3];
        c1Array[0] = c1.getRed();
        c1Array[1] = c1.getGreen();
        c1Array[2] = c1.getBlue();
        c2Array[0] = c2.getRed();
        c2Array[1] = c2.getGreen();
        c2Array[2] = c2.getBlue();
        for (int i = 0; i < 3; ++i) {
            int n = i;
            c1Array[n] = c1Array[n] ^ c2Array[i];
        }
        return new Color(c1Array[0], c1Array[1], c1Array[2]);
    }

    public static void setupSelection(Graphics g, RenderState rs) {
        Color selectionColor = DEFAULT_SELECTION_COLOR;
        Color currentColor = DEFAULT_BACKGROUND_COLOR;
        Color bg1 = ColorFactory.getInstance().getBackgroundColor();
        Color bg3 = rs.getBackgroundInfo() == null ? null : rs.getBackgroundInfo().backgroundColor;
        Color bg4 = rs.getTextBackgroundColor();
        Color over = rs.getOverlayColor();
        if (bg1 != null) {
            currentColor = bg1;
            selectionColor = ColorFactory.getSelectionColor(bg1, DEFAULT_SELECTION_COLOR, selectionColor);
        }
        if (bg3 != null) {
            currentColor = bg3;
            selectionColor = ColorFactory.getSelectionColor(bg3, DEFAULT_SELECTION_COLOR, selectionColor);
        }
        if (bg4 != null) {
            currentColor = bg4;
            selectionColor = ColorFactory.getSelectionColor(bg4, DEFAULT_SELECTION_COLOR, selectionColor);
        }
        if (over != null) {
            currentColor = over;
            selectionColor = ColorFactory.getSelectionColor(over, DEFAULT_SELECTION_COLOR, selectionColor);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (ColorFactory.isMac() || ColorFactory.isUnix()) {
                g2D.setComposite(AlphaComposite.SrcOver.derive(0.1f));
                g2D.setColor(DEFAULT_SELECTION_COLOR);
            } else {
                g2D.setComposite(XorComposite.INSTANCE);
                g2D.setColor(selectionColor);
            }
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac") || os.contains("os x");
    }

    public static boolean isUnix() {
        return !ColorFactory.isWindows() && !ColorFactory.isMac();
    }

    public static Color getSelectionColor(Color bg, Color selectionColorDefault, Color selectionColorNew) {
        Color xorColor = ColorFactory.getXorColor(bg, selectionColorDefault);
        String xorColorString = ColorFactory.getColorTone(xorColor);
        if (!xorColorString.equalsIgnoreCase("blue")) {
            selectionColorNew = xorColor;
        }
        return selectionColorNew;
    }

    private static class XorContext
    implements CompositeContext {
        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            int w = Math.min(src.getWidth(), dstIn.getWidth());
            int h = Math.min(src.getHeight(), dstIn.getHeight());
            int[] srcRgbaTest = new int[]{-50, -50, -50, -50};
            int[] dstRgbaTest = new int[]{-50, -50, -50, -50};
            int mSrc = src.getPixel(0, 0, srcRgbaTest)[3];
            int mDst = dstIn.getPixel(0, 0, dstRgbaTest)[3];
            mSrc = mSrc == -50 ? 3 : 4;
            mDst = mDst == -50 ? 3 : 4;
            int[] srcRgba = new int[4 * w];
            int[] dstRgba = new int[4 * w];
            for (int y = 0; y < h; ++y) {
                src.getPixels(0, y, w, 1, srcRgba);
                dstIn.getPixels(0, y, w, 1, dstRgba);
                for (int x = 0; x < w; ++x) {
                    int m1 = x * mSrc;
                    int m2 = x * mDst;
                    for (int i = 0; i < 3; ++i) {
                        int n = m2 + i;
                        dstRgba[n] = dstRgba[n] ^ srcRgba[m1 + i];
                    }
                }
                dstOut.setPixels(0, y, w, 1, dstRgba);
            }
        }

        @Override
        public void dispose() {
        }
    }

    public static class XorComposite
    implements Composite {
        public static XorComposite INSTANCE = new XorComposite();
        private final XorContext context = new XorContext();

        @Override
        public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
            return this.context;
        }
    }
}

