/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.serialization;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.PayloadHelper;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class LinkSpecSerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Collection<MaltegoLinkSpec> specs) throws CollaborationException {
        String str;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.write(specs, bos);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ex) {
                throw new CollaborationException(ex, true);
            }
        }
        try {
            str = bos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new CollaborationException(ex, true);
        }
        return str;
    }

    public void write(Collection<MaltegoLinkSpec> specs, OutputStream os) throws CollaborationException {
        com.paterva.maltego.entity.api.LinkSpecSerializer serializer = com.paterva.maltego.entity.api.LinkSpecSerializer.getDefault();
        try {
            for (MaltegoLinkSpec spec : specs) {
                serializer.write(spec, os);
            }
        }
        catch (XmlSerializationException ex) {
            throw new CollaborationException(ex, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MaltegoLinkSpec> read(String xml) throws CollaborationException {
        Collection<String> payloads = PayloadHelper.splitXml("MaltegoLink", xml);
        ArrayList<MaltegoLinkSpec> specs = new ArrayList<MaltegoLinkSpec>();
        com.paterva.maltego.entity.api.LinkSpecSerializer serializer = com.paterva.maltego.entity.api.LinkSpecSerializer.getDefault();
        try {
            for (String payload : payloads) {
                ByteArrayInputStream is = null;
                try {
                    is = new ByteArrayInputStream(payload.getBytes("UTF-8"));
                    MaltegoLinkSpec spec = serializer.read((InputStream)is);
                    specs.add(spec);
                }
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                    }
                    catch (IOException ex) {
                        throw new CollaborationException(ex, true);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CollaborationException(ex, true);
        }
        return specs;
    }
}

