/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.map;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.serializers.GraphSerializationException;
import com.paterva.maltego.serializers.map.PartMapTranslator;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyValueFormat;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.SpecFactory;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.IPAddress;
import com.paterva.maltego.typing.types.InternalFile;
import com.paterva.maltego.typing.types.PhoneNumber;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import com.pinkmatter.types.Blob;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class PartMapReader
extends PartMapTranslator {
    private static final Logger LOG = Logger.getLogger(PartMapReader.class.getName());

    public Set<MaltegoEntity> fromMaps(EntityRegistry registry, EntityFactory factory, Collection<Map<String, Object>> maps) throws GraphSerializationException {
        HashSet<MaltegoEntity> parts = new HashSet<MaltegoEntity>();
        for (Map<String, Object> map : maps) {
            parts.add(this.entityFromMap(registry, factory, map));
        }
        return parts;
    }

    public Set<MaltegoLink> fromMaps(LinkRegistry registry, LinkFactory factory, Collection<Map<String, Object>> maps) throws GraphSerializationException {
        HashSet<MaltegoLink> parts = new HashSet<MaltegoLink>();
        for (Map<String, Object> map : maps) {
            parts.add(this.linkFromMap(registry, factory, map));
        }
        return parts;
    }

    public MaltegoEntity entityFromMap(EntityRegistry registry, EntityFactory factory, Map<String, Object> map) throws GraphSerializationException {
        MaltegoEntity entity = (MaltegoEntity)this.fromMap((SpecRegistry)registry, (SpecFactory)factory, map);
        LOG.log(Level.FINE, "Map:\n{0}\nEntity:\n{1}", new Object[]{map, entity});
        return entity;
    }

    public MaltegoLink linkFromMap(LinkRegistry registry, LinkFactory factory, Map<String, Object> map) throws GraphSerializationException {
        MaltegoLink link = (MaltegoLink)this.fromMap((SpecRegistry)registry, (SpecFactory)factory, map);
        LOG.log(Level.FINE, "Map:\n{0}\nLink:\n{1}", new Object[]{map, link});
        return link;
    }

    public MaltegoPart fromMap(SpecRegistry registry, SpecFactory factory, Map<String, Object> map) throws GraphSerializationException {
        boolean isEntity = registry instanceof EntityRegistry;
        String type = (String)map.get("type");
        if (!isEntity) {
            type = this.getLinkMappings().linkTypeNameToLongName(type);
        }
        MaltegoEntity part = isEntity ? this.createEntity(map, (EntityFactory)factory, type) : this.createLink(map, (LinkFactory)factory, type);
        part.beginPropertyUpdating();
        this.setProperties((MaltegoPart)part, map, registry, type);
        this.setBookmark((MaltegoPart)part, map);
        this.setNotes((MaltegoPart)part, map);
        this.setDisplayInfos((MaltegoPart)part, map);
        if (isEntity) {
            MaltegoEntity entity = part;
            this.setWeight(entity, map);
            this.setPropertyMappings(entity, map);
            this.setOverlays(entity, map);
        } else {
            MaltegoLink link = (MaltegoLink)part;
            this.setReversed(link, map);
        }
        this.setCachedValues((MaltegoPart)part, map);
        part.endPropertyUpdating(false);
        return part;
    }

    private MaltegoEntity createEntity(Map<String, Object> map, EntityFactory factory, String type) throws GraphSerializationException {
        try {
            EntityID id = EntityID.parse((String)((String)map.get("id")));
            MaltegoEntity entity = factory.createInstance(type, false, id, false);
            return entity;
        }
        catch (TypeInstantiationException ex) {
            throw new GraphSerializationException(ex, true);
        }
    }

    private MaltegoLink createLink(Map<String, Object> map, LinkFactory factory, String type) {
        LinkID id = LinkID.parse((String)((String)map.get("id")));
        MaltegoLink link = factory.createInstance(type, id, false);
        return link;
    }

    private void setProperties(MaltegoPart part, Map<String, Object> map, SpecRegistry registry, String type) throws GraphSerializationException {
        DisplayDescriptorCollection descriptors = InheritanceHelper.getAggregatedProperties((SpecRegistry)registry, (String)type);
        Map<String, Object> properties = (HashMap<String, Object>)map.get("properties");
        if (properties != null) {
            if (part instanceof MaltegoLink) {
                properties = this.shortToLongNames(properties, "maltego.link.manual-link".equals(part.getTypeName()));
            }
            properties = new HashMap<String, Object>(properties);
            this.setStaticProperties(part, descriptors, properties);
            this.setDynamicProperties(part, properties);
            if (part instanceof MaltegoLink) {
                this.setLinkDefaultValues(part);
            }
        }
    }

    private void setStaticProperties(MaltegoPart part, DisplayDescriptorCollection descriptors, Map<String, Object> properties) throws GraphSerializationException {
        Iterator<Map.Entry<String, Object>> itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Object> entry = itr.next();
            String propName = entry.getKey();
            DisplayDescriptor dd = descriptors.get(propName);
            if (dd == null) continue;
            Object propMapObj = entry.getValue();
            if (propMapObj instanceof Map) {
                Map propMap = (Map)propMapObj;
                Object propMapValue = this.getPropertyMapValue(propMap);
                if (propMap.containsKey("propertyValueFormat")) {
                    dd.setPropertyValueFormat(PropertyValueFormat.parse(propMap.get("propertyValueFormat")));
                }
                Object propValue = this.translatePropertyValue(dd.getTypeDescriptor(), propMapValue, dd.getPropertyValueFormat());
                part.addProperty((PropertyDescriptor)dd);
                part.setValue((PropertyDescriptor)dd, propValue, false, false);
            }
            itr.remove();
        }
    }

    private void setDynamicProperties(MaltegoPart part, Map<String, Object> properties) throws GraphSerializationException {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propName = entry.getKey();
            Object propMapObj = entry.getValue();
            if (!(propMapObj instanceof Map)) continue;
            Map propMap = (Map)propMapObj;
            TypeDescriptor type = TypeRegistry.getDefault().getType((String)propMap.get("type"));
            Object propValue = this.getPropertyMapValue(propMap);
            String displayName = (String)propMap.get("displayName");
            Boolean hidden = (Boolean)propMap.get("hidden");
            Boolean readonly = (Boolean)propMap.get("readonly");
            Boolean nullable = (Boolean)propMap.get("nullable");
            PropertyValueFormat propertyValueFormat = PropertyValueFormat.parse(propMap.get("propertyValueFormat"));
            PropertyDescriptor descriptor = new PropertyDescriptor(type.getType(), propName, displayName != null ? displayName : propName);
            descriptor.setHidden(hidden != null ? hidden : false);
            descriptor.setReadonly(readonly != null ? readonly : false);
            descriptor.setNullable(nullable != null ? nullable : true);
            descriptor.setPropertyValueFormat(propertyValueFormat);
            propValue = this.translatePropertyValue(type, propValue);
            part.addProperty(descriptor);
            part.setValue(descriptor, propValue, false, false);
        }
    }

    void setOverlays(MaltegoEntity entity, Map<String, Object> map) {
        if (!map.containsKey("overlays")) {
            return;
        }
        Object object = map.get("overlays");
        if (!(object instanceof Map)) {
            return;
        }
        Map overlayMap = (Map)object;
        for (Map overlayFields : overlayMap.values()) {
            String propertyName = (String)overlayFields.get("propertyName");
            String position = (String)overlayFields.get("position");
            String type = (String)overlayFields.get("type");
            entity.addOverlay(new OverlayDescriptor(propertyName, position, type));
        }
    }

    private void setBookmark(MaltegoPart part, Map<String, Object> map) {
        Integer bookmark = (Integer)map.get("bookmark");
        if (bookmark == null) {
            part.setBookmark(Integer.valueOf(-1));
        } else {
            part.setBookmark(bookmark);
        }
    }

    private void setWeight(MaltegoEntity entity, Map<String, Object> map) {
        Integer weight = (Integer)map.get("weight");
        if (weight != null) {
            entity.setWeight(weight);
        }
    }

    private void setReversed(MaltegoLink link, Map<String, Object> map) {
        Boolean reversed = (Boolean)map.get("reversed");
        if (reversed != null) {
            link.setReversed(reversed);
        }
    }

    private void setNotes(MaltegoPart part, Map<String, Object> map) {
        Map notesMap = (Map)map.get("notes");
        if (notesMap != null) {
            Boolean showNotes;
            String notes = (String)notesMap.get("value");
            if (!StringUtilities.isNullOrEmpty((String)notes)) {
                part.setNotes(notes);
            }
            if ((showNotes = (Boolean)notesMap.get("show")) != null) {
                part.setShowNotes(showNotes);
            }
        }
    }

    private void setDisplayInfos(MaltegoPart part, Map<String, Object> map) {
        Object displayInfoObj = map.get("displayInfo");
        if (displayInfoObj != null) {
            if (displayInfoObj.getClass().isArray()) {
                this.setDisplayInfo(part, (Map[])displayInfoObj);
            } else if (displayInfoObj instanceof Map) {
                Map diMap = (Map)displayInfoObj;
                if (diMap.get("name") != null) {
                    this.setDisplayInfo(part, new Map[]{diMap});
                } else {
                    this.setDisplayInfo(part, diMap);
                }
            }
        }
    }

    private void setDisplayInfo(MaltegoPart part, Map<String, String>[] displayInfoArray) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Display Info Array: {0}", Arrays.toString(displayInfoArray));
        }
        for (Map<String, String> displayInfoMap : displayInfoArray) {
            String name = displayInfoMap.get("name");
            String value = displayInfoMap.get("value");
            part.getOrCreateDisplayInformation().add(name, value);
        }
    }

    private void setDisplayInfo(MaltegoPart part, Map<String, Object> displayInfoMap) {
        LOG.log(Level.FINE, "Display Info Map: {0}", displayInfoMap);
        for (Map.Entry<String, Object> entry : displayInfoMap.entrySet()) {
            String[] values;
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (!value.getClass().isArray()) {
                part.getOrCreateDisplayInformation().add(name, (String)value);
                continue;
            }
            Object[] valueArr = (Object[])value;
            for (String v : values = Arrays.asList(valueArr).toArray(new String[valueArr.length])) {
                part.getOrCreateDisplayInformation().add(name, v);
            }
        }
    }

    private void setPropertyMappings(MaltegoEntity entity, Map<String, Object> map) {
        String valuePropName = (String)map.get("valuePropName");
        if (StringUtils.isNotBlank((CharSequence)valuePropName)) {
            entity.setValueProperty(new PropertyDescriptor(String.class, valuePropName));
        }
        String displayExpr = (String)map.get("displayPropName");
        entity.setDisplayValueExpression(displayExpr);
        String imgExpr = (String)map.get("imagePropName");
        entity.setImageExpression(imgExpr);
    }

    private Map<String, Object> shortToLongNames(Map<String, Object> properties, boolean manualLink) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            props.put(this.getLinkMappings().linkPropNameToLongName(entry.getKey(), manualLink), entry.getValue());
        }
        return props;
    }

    private void setLinkDefaultValues(MaltegoPart part) {
        PropertyDescriptorCollection properties = part.getProperties();
        for (PropertyDescriptor property : properties) {
            Object value;
            String name = property.getName();
            if (!"maltego.link.transform.version".equals(name) || (value = part.getValue(property)) != null) continue;
            part.setValue(property, (Object)"1.0.0");
        }
    }

    private void setCachedValues(MaltegoPart part, Map<String, Object> map) {
        part.setValueString((String)map.get("valueStr"));
        part.setDisplayString((String)map.get("displayValueStr"));
        part.setHasAttachments((Boolean)map.get("hasAttachments"));
        Boolean labelReadonly = (Boolean)map.get("labelReadOnly");
        part.setLabelReadonly(labelReadonly != null ? labelReadonly : false);
        if (part instanceof MaltegoEntity) {
            MaltegoEntity entity = (MaltegoEntity)part;
            entity.setCachedImageKey(this.translateImageCacheObject(map.get("imageValue")));
        }
    }

    private Object translateImageCacheObject(Object value) {
        if (value != null && Map.class.isAssignableFrom(value.getClass())) {
            value = this.attachmentsFromMap((Map)value);
        }
        return value;
    }

    public Object translatePropertyValue(TypeDescriptor td, Object value) throws GraphSerializationException {
        return this.translatePropertyValue(td, value, PropertyValueFormat.getDefault());
    }

    public Object translatePropertyValue(TypeDescriptor td, Object value, PropertyValueFormat propertyValueFormat) throws GraphSerializationException {
        if (value == null) {
            return null;
        }
        Class<String> type = td.getType();
        Class expectedType = type;
        if (Byte.TYPE.equals(type)) {
            expectedType = String.class;
        } else if (Character.TYPE.equals(type)) {
            expectedType = String.class;
        } else if (DateTime.class.equals(type)) {
            expectedType = Long.TYPE;
        } else if (TimeSpan.class.equals(type)) {
            expectedType = Long.class;
        } else if (FastURL.class.equals(type)) {
            expectedType = String.class;
        } else if (InternalFile.class.equals(type)) {
            expectedType = Integer.class;
        } else if (Color.class.equals(type)) {
            expectedType = String.class;
        } else if (Attachments.class.equals(type)) {
            expectedType = Map.class;
        } else if (File.class.equals(type)) {
            expectedType = String.class;
        } else if (DateRange.class.equals(type)) {
            expectedType = String.class;
        } else if (IPAddress.class.equals(type)) {
            expectedType = String.class;
        } else if (PhoneNumber.class.equals(type)) {
            expectedType = String.class;
        } else if (Image.class.equals(type)) {
            expectedType = Blob.class;
        }
        if (TypeRegistry.getDefault().getType(expectedType) != null && (value = Converter.convert((Object)value, expectedType, (PropertyValueFormat)propertyValueFormat)) == null) {
            return null;
        }
        if (!expectedType.isArray() && expectedType.isPrimitive()) {
            expectedType = Converter.getReferenceType((Class)expectedType);
        }
        this.checkType(expectedType, value);
        if (Byte.TYPE.equals(type)) {
            return Byte.parseByte((String)value);
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf(((String)value).charAt(0));
        }
        if (DateTime.class.equals(type)) {
            return new DateTime(((Long)value).longValue());
        }
        if (TimeSpan.class.equals(type)) {
            return new TimeSpan(((Long)value).longValue());
        }
        if (FastURL.class.equals(type)) {
            return new FastURL((String)value);
        }
        if (InternalFile.class.equals(type)) {
            return new InternalFile(((Integer)value).intValue());
        }
        if (Color.class.equals(type)) {
            return ColorUtilities.decode((String)((String)value));
        }
        if (Attachments.class.equals(type)) {
            return this.attachmentsFromMap((Map)value);
        }
        if (File.class.equals(type)) {
            return new File((String)value);
        }
        if (DateRange.class.equals(type)) {
            return DateRange.parse((String)((String)value));
        }
        if (IPAddress.class.equals(type)) {
            String creationString = ((String)value).split("\\-")[1];
            return IPAddress.parse((String)creationString);
        }
        if (PhoneNumber.class.equals(type)) {
            String creationString = ((String)value).split("@")[1];
            return PhoneNumber.parse((String)creationString);
        }
        if (Image.class.equals(type)) {
            Blob blob = (Blob)value;
            return ImageUtils.bytesToImage((byte[])blob.get());
        }
        return value;
    }

    private void checkType(Class<? extends Object> expected, Object value) throws GraphSerializationException {
        Class<?> clazz = value.getClass();
        if (!expected.isAssignableFrom(clazz)) {
            throw new GraphSerializationException("Invalid type, expected " + expected + " but found " + clazz, true);
        }
    }

    private Attachments attachmentsFromMap(Map map) {
        Attachments attachments = new Attachments();
        Object primary = map.get("primary");
        Map attsMap = (Map)map.get("atts");
        if (attsMap != null) {
            for (Map.Entry entry : attsMap.entrySet()) {
                int id = Integer.parseInt((String)entry.getKey());
                String source = (String)entry.getValue();
                Attachment attachment = new Attachment(id, new FastURL(source));
                attachments.add((Object)attachment);
                if (primary == null || (Integer)primary != id) continue;
                attachments.setPrimaryImage(attachment);
            }
        }
        return attachments;
    }

    private Object getPropertyMapValue(Map<String, Object> propertyMap) {
        return propertyMap.entrySet().stream().filter(prop -> ((String)prop.getKey()).startsWith("value")).findFirst().map(prop -> prop.getValue()).orElse(null);
    }
}

