/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.remote;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.protocol.api.DiscoveryInfo;
import com.paterva.maltego.transform.protocol.api.DiscoveryServer;
import com.paterva.maltego.transform.protocol.api.TransformApplicationDescriptor;
import com.paterva.maltego.transform.protocol.v2api.messaging.DiscoveryResponse;
import java.util.ArrayList;
import java.util.Collection;

public class DiscoveryInfoTranslator {
    private final String _seedUrl;

    public DiscoveryInfoTranslator(String seedUrl) {
        this._seedUrl = seedUrl;
    }

    public DiscoveryInfo translate(DiscoveryResponse response) {
        DiscoveryInfo info = new DiscoveryInfo(response.getServerName());
        this.addServers(info.getServers(), response.getSeedServers());
        this.addApplications(info.getApplications(), response.getTransformApplications());
        return info;
    }

    private void addApplications(Collection<TransformApplicationDescriptor> applications, ArrayList<DiscoveryResponse.TransformApplicationDescriptor> transformApplications) {
        for (DiscoveryResponse.TransformApplicationDescriptor d : transformApplications) {
            applications.add(this.translate(d));
        }
    }

    private TransformApplicationDescriptor translate(DiscoveryResponse.TransformApplicationDescriptor d) {
        TransformApplicationDescriptor descriptor = new TransformApplicationDescriptor(d.getName(), d.getUrl(), this._seedUrl, d.getVersion(), d.getDisclaimer(), ProtocolVersion.V2_0);
        descriptor.setRequiresKey(d.getRequiresKey());
        descriptor.setRegistrationUrl(d.getRegistrationUrl());
        descriptor.setOverwriteConfig(d.isOverwriteConfig());
        descriptor.setV3Url(d.getV3URL());
        return descriptor;
    }

    private void addServers(Collection<DiscoveryServer> servers, ArrayList<DiscoveryResponse.SeedServerDescriptor> seedServers) {
        for (DiscoveryResponse.SeedServerDescriptor d : seedServers) {
            servers.add(this.translate(d));
        }
    }

    private DiscoveryServer translate(DiscoveryResponse.SeedServerDescriptor d) {
        DiscoveryServer server = new DiscoveryServer();
        server.setUrl(d.getUrl());
        return server;
    }
}

