/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class ToolBarLabel
extends JPanel {
    private final JLabel _label = new JLabel();

    public ToolBarLabel() {
        this("", true);
    }

    public ToolBarLabel(String text) {
        this(text, true);
    }

    public ToolBarLabel(String text, boolean opaque) {
        this.init();
        this.setText(text, opaque);
    }

    private void init() {
        UIDefaults LAF = UIManager.getLookAndFeelDefaults();
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new CompoundBorder(new EmptyBorder(10, 0, 0, 0), new MatteBorder(2, 0, 0, 0, LAF.getColor("graph-toolbar-separator-color"))));
        this._label.setOpaque(true);
        this._label.setBackground(LAF.getColor("graph-toolbar-label-bg"));
        this._label.setForeground(LAF.getColor("graph-toolbar-label-fb"));
        this._label.setBorder(new EmptyBorder(3, 2, 5, 2));
        this._label.setHorizontalAlignment(0);
        this._label.setHorizontalTextPosition(0);
        Font f = this._label.getFont();
        this.add(this._label);
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean opaque) {
        if (!opaque) {
            this._label.setForeground(this._label.getBackground());
        }
        this._label.setText(text);
        BufferedImage image = new BufferedImage(500, 200, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setFont(this._label.getFont());
        FontMetrics fm = g2.getFontMetrics();
        Dimension preferredSize = new Dimension();
        Insets i = this._label.getInsets();
        preferredSize.width = Math.max(fm.stringWidth("Layout"), fm.stringWidth("Freeze")) + 1 + i.left + i.right;
        preferredSize.height = fm.getHeight() + i.top + i.bottom;
        if (text == null || text.isEmpty()) {
            preferredSize.height = 4;
        }
        this._label.setMinimumSize(preferredSize);
        this._label.setPreferredSize(preferredSize);
        this._label.setMaximumSize(preferredSize);
        this.setMinimumSize(preferredSize);
        g2.dispose();
    }

    public String getText() {
        return this._label.getText();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(0, y, width, height);
    }
}

