/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.about;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.java.config.ui.JavaOptions;
import com.paterva.maltego.licensing.LicenseDateFormat;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.UserInfo;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.welcome.about.AboutBoxControl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Locale;
import javax.swing.JDialog;
import org.openide.modules.Places;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public final class AboutBoxAction
extends CallableSystemAction {
    public void performAction() {
        Component ctrl = this.createAbountControl();
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        JDialog dialog = new JDialog(mainWindow);
        if (!GraphicsUtil.useCustomLafFrameDecorations((boolean)false)) {
            dialog.setUndecorated(true);
        } else {
            dialog.getRootPane().setWindowDecorationStyle(0);
        }
        dialog.setModal(true);
        dialog.add(ctrl);
        dialog.pack();
        Rectangle screenBounds = mainWindow.getGraphicsConfiguration().getBounds();
        int x = (screenBounds.width - dialog.getWidth()) / 2 + screenBounds.x;
        int y = (screenBounds.height - dialog.getHeight()) / 2 + screenBounds.y;
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    private Component createAbountControl() {
        A licenseMode = LicenseManager.A().A(false);
        UserInfo userInfo = new UserInfo(licenseMode);
        boolean isInBeta = MaltegoIdProductRestrictions.isInBeta((A)licenseMode);
        AboutBoxControl ctrl = new AboutBoxControl(isInBeta);
        ctrl.setProductTitle(Version.getCurrent().toString(true, true, true, isInBeta, !licenseMode.U()));
        ctrl.setLicenseType(userInfo.getLicenseType());
        if (!licenseMode.D()) {
            String name = userInfo.isEmailUser() ? userInfo.getFullName() : userInfo.getUsername();
            String alias = userInfo.getAlias();
            if (!StringUtilities.isNullOrEmpty((String)alias)) {
                name = name + " (" + alias + ")";
            }
            ctrl.setOwner(name);
            ctrl.setLicenseKey(licenseMode.B() ? licenseMode.A().C() : "Unlicensed");
            if (licenseMode.L()) {
                ctrl.setValid("\u221e");
            } else {
                Long from = userInfo.getValidFrom();
                Long to = userInfo.getValidTo();
                if (from != null && to != null) {
                    String validFrom = LicenseDateFormat.format((long)from);
                    String validTo = LicenseDateFormat.format((long)to);
                    ctrl.setValid(validFrom + " to " + validTo);
                }
            }
        }
        String subscriptionPlan = "";
        if (licenseMode.B()) {
            subscriptionPlan = licenseMode.J().J().A();
        } else if (licenseMode.W()) {
            subscriptionPlan = licenseMode.R().J().A();
        }
        ctrl.setSubscriptionPlan(subscriptionPlan);
        ctrl.setOS(this.getOSInfo());
        ctrl.setJavaVersion(System.getProperty("java.version", "unknown"));
        ctrl.setJavaVM(System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", ""));
        ctrl.setMaxMemory(JavaOptions.getMaxMemory() + " MB");
        ctrl.setMaxHeap(StringUtilities.bytesToString((long)Runtime.getRuntime().maxMemory()));
        ctrl.setLocale(Locale.getDefault().toString());
        String userDir = Places.getUserDirectory().getAbsolutePath();
        ctrl.setUserDirBase(userDir.replaceFirst("(.*[^\\.]+)((\\.?maltego)|(build)).*", "$1"));
        ctrl.setUserDir(userDir.replaceFirst(".*[^\\.]+((\\.?maltego)|(build))", "$1"));
        return ctrl;
    }

    private String getOSInfo() {
        String arch = System.getProperty("os.arch", "unknown");
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("os.name", "unknown"));
        sb.append(" ");
        sb.append(System.getProperty("os.version", "unknown"));
        sb.append(" ");
        sb.append(arch.equalsIgnoreCase("amd64") ? "x64" : arch);
        return sb.toString();
    }

    public String getName() {
        return NbBundle.getMessage(AboutBoxAction.class, (String)"CTL_AboutBoxAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

