/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.api.TransformCallback;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import com.paterva.maltego.transform.runner.api.TransformRunnerContext;
import com.paterva.maltego.transform.runner.api.TransformsRunContext;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.util.Args;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class TransformRunContext {
    private final TransformRunnerContext runnerContext;
    private final TransformCallback callback;
    private final AtomicInteger outputEntityCount = new AtomicInteger(0);

    public TransformRunContext(TransformRunnerContext runnerContext, TransformCallback callback) {
        Args.notNull((Object)runnerContext, (String)"runnerContext");
        Args.notNull((Object)callback, (String)"callback");
        this.runnerContext = runnerContext;
        this.callback = callback;
    }

    public TransformsRunContext getTransformsContext() {
        return this.runnerContext.getTransformsContext();
    }

    public GraphID getTargetGraphID() {
        return this.runnerContext.getTargetGraphID();
    }

    public Map<EntityID, MaltegoEntity> getInputEntities() {
        return this.runnerContext.getInputEntities();
    }

    public Map<MaltegoLink, LinkEntityIDs> getInputLinks() {
        return this.runnerContext.getInputLinks();
    }

    public TransformDefinition getTransform() {
        return this.runnerContext.getTransform();
    }

    public DataSource getTransformInputs() {
        return this.runnerContext.getTransformInputs();
    }

    public EntityRegistry getEntityRegistry() {
        return this.runnerContext.getEntityRegistry();
    }

    public EntityFactory getEntityFactory() {
        return this.runnerContext.getEntityFactory();
    }

    public LinkFactory getLinkFactory() {
        return this.runnerContext.getLinkFactory();
    }

    public Optional<TransformServerInfo> getServer() {
        return this.runnerContext.getServer();
    }

    public Optional<String> getServerUrl() {
        return this.runnerContext.getServerUrl();
    }

    public TransformCallback getCallback() {
        return this.callback;
    }

    public int getOutputEntityCount() {
        return this.outputEntityCount.get();
    }

    public void incrementOutputEntityCount(int amount) {
        this.outputEntityCount.addAndGet(amount);
    }

    public TransformRunOrigin getRunOrigin() {
        return this.runnerContext.getRunOrigin();
    }
}

