/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.constraints.execution.property;

import com.maltego.tx3.java.api.constraints.ConstraintStringMatchType;
import com.maltego.tx3.java.api.constraints.LogicalOperation;
import com.maltego.tx3.java.api.constraints.execution.InputConstraint;
import java.util.regex.Pattern;

public abstract class AbstractStringMatchConstraint
extends InputConstraint {
    protected final String value;
    protected final ConstraintStringMatchType matchType;
    private final Pattern regexPattern;

    protected AbstractStringMatchConstraint(String value, ConstraintStringMatchType matchType) {
        this.value = value;
        this.matchType = matchType == null ? ConstraintStringMatchType.EQUALS : matchType;
        this.regexPattern = matchType == ConstraintStringMatchType.REGEX ? Pattern.compile(value) : null;
    }

    protected boolean matches(String valueToCheck, Boolean ignoreCase) {
        String valueToCompare = this.value;
        if (valueToCheck == null) {
            return false;
        }
        if (ignoreCase != null && ignoreCase.booleanValue()) {
            valueToCheck = valueToCheck.toLowerCase();
            valueToCompare = valueToCompare.toLowerCase();
        }
        switch (this.matchType) {
            case CONTAINS: {
                return valueToCheck.contains(valueToCompare);
            }
            case STARTSWITH: {
                return valueToCheck.startsWith(valueToCompare);
            }
            case ENDSWITH: {
                return valueToCheck.endsWith(valueToCompare);
            }
            case EQUALS: {
                return valueToCheck.equals(valueToCompare);
            }
            case EQUALSIGNORECASE: {
                return valueToCheck.equalsIgnoreCase(valueToCompare);
            }
            case REGEX: {
                return this.regexPattern != null && this.regexPattern.matcher(valueToCheck).matches();
            }
        }
        throw new IllegalArgumentException("Invalid matchType: " + (Object)((Object)this.matchType));
    }

    @Override
    public LogicalOperation getConstraintOperation() {
        return LogicalOperation.ALL;
    }

    public String getValue() {
        return this.value;
    }

    public ConstraintStringMatchType getMatchType() {
        return this.matchType;
    }

    public boolean getIgnoreCase() {
        return false;
    }
}

