/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.constraints.execution.property;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.constraints.ConstraintTypeEnum;
import com.maltego.tx3.java.api.constraints.LogicalOperation;
import com.maltego.tx3.java.api.constraints.execution.InputConstraint;
import com.maltego.tx3.java.api.execution.Entity;
import com.maltego.tx3.java.api.execution.Property;
import java.util.List;

abstract class AbstractPropertyCompositeConstraint
extends InputConstraint {
    protected final List<InputConstraint> constraints;
    protected final LogicalOperation operation;

    @JsonCreator
    protected AbstractPropertyCompositeConstraint(@JsonProperty(value="constraints") List<InputConstraint> constraints, LogicalOperation operation) {
        this.constraints = constraints;
        this.operation = operation;
        this.constraintType = ConstraintTypeEnum.GROUP_CONSTRAINT;
    }

    protected boolean evaluateConstraints(Object inputValue, String operation) {
        switch (operation) {
            case "all": {
                return this.constraints.stream().allMatch(c -> inputValue instanceof Property && c.getConstraintType() == ConstraintTypeEnum.PROPERTY ? c.evaluate((Property)inputValue) : c.evaluate(inputValue));
            }
            case "any": {
                return this.constraints.stream().anyMatch(c -> inputValue instanceof Property && c.getConstraintType() == ConstraintTypeEnum.PROPERTY ? c.evaluate((Property)inputValue) : c.evaluate(inputValue));
            }
            case "none": {
                return this.constraints.stream().noneMatch(c -> inputValue instanceof Property && c.getConstraintType() == ConstraintTypeEnum.PROPERTY ? c.evaluate((Property)inputValue) : c.evaluate(inputValue));
            }
        }
        throw new IllegalArgumentException("Invalid operation: " + operation);
    }

    @Override
    public boolean evaluate(Entity inputValue) {
        return this.evaluate((Object)inputValue);
    }

    @Override
    public boolean evaluate(Property inputValue) {
        return this.evaluate((Object)inputValue);
    }

    @Override
    public LogicalOperation getConstraintOperation() {
        return this.operation;
    }

    @Override
    public List<InputConstraint> getInnerConstraints() {
        return this.constraints;
    }
}

