/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.BBoxCalculator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class ShapeCollection<S extends Shape>
extends AbstractList<S>
implements Shape {
    protected final SpatialContext ctx;
    protected final List<S> shapes;
    protected final Rectangle bbox;

    public ShapeCollection(List<S> shapes, SpatialContext ctx) {
        if (!(shapes instanceof RandomAccess)) {
            throw new IllegalArgumentException("Shapes arg must implement RandomAccess: " + shapes.getClass());
        }
        this.shapes = shapes;
        this.ctx = ctx;
        this.bbox = this.computeBoundingBox(shapes, ctx);
    }

    protected Rectangle computeBoundingBox(Collection<? extends Shape> shapes, SpatialContext ctx) {
        if (shapes.isEmpty()) {
            return ctx.makeRectangle(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        BBoxCalculator bboxCalc = new BBoxCalculator(ctx);
        for (Shape shape : shapes) {
            bboxCalc.expandRange(shape.getBoundingBox());
        }
        return bboxCalc.getBoundary();
    }

    public List<S> getShapes() {
        return this.shapes;
    }

    @Override
    public S get(int index) {
        return (S)((Shape)this.shapes.get(index));
    }

    @Override
    public int size() {
        return this.shapes.size();
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    @Override
    public Point getCenter() {
        return this.bbox.getCenter();
    }

    @Override
    public boolean hasArea() {
        for (Shape geom : this.shapes) {
            if (!geom.hasArea()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ShapeCollection getBuffered(double distance, SpatialContext ctx) {
        ArrayList<Shape> bufColl = new ArrayList<Shape>(this.size());
        for (Shape shape : this.shapes) {
            bufColl.add(shape.getBuffered(distance, ctx));
        }
        return ctx.makeCollection(bufColl);
    }

    @Override
    public SpatialRelation relate(Shape other) {
        SpatialRelation bboxSect = this.bbox.relate(other);
        if (bboxSect == SpatialRelation.DISJOINT || bboxSect == SpatialRelation.WITHIN) {
            return bboxSect;
        }
        boolean containsWillShortCircuit = other instanceof Point || this.relateContainsShortCircuits();
        SpatialRelation sect = null;
        for (Shape shape : this.shapes) {
            SpatialRelation nextSect = shape.relate(other);
            if ((sect = sect == null ? nextSect : sect.combine(nextSect)) == SpatialRelation.INTERSECTS) {
                return SpatialRelation.INTERSECTS;
            }
            if (sect != SpatialRelation.CONTAINS || !containsWillShortCircuit) continue;
            return SpatialRelation.CONTAINS;
        }
        return sect;
    }

    protected boolean relateContainsShortCircuits() {
        return true;
    }

    protected static boolean computeMutualDisjoint(List<? extends Shape> shapes) {
        for (int i = 1; i < shapes.size(); ++i) {
            Shape shapeI = shapes.get(i);
            for (int j = 0; j < i; ++j) {
                Shape shapeJ = shapes.get(j);
                if (!shapeJ.relate(shapeI).intersects()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        double MAX_AREA = this.bbox.getArea(ctx);
        double sum = 0.0;
        for (Shape geom : this.shapes) {
            if (!((sum += geom.getArea(ctx)) >= MAX_AREA)) continue;
            return MAX_AREA;
        }
        return sum;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("ShapeCollection(");
        int i = 0;
        for (Shape shape : this.shapes) {
            if (i++ > 0) {
                buf.append(", ");
            }
            buf.append(shape);
            if (buf.length() <= 150) continue;
            buf.append(" ...").append(this.shapes.size());
            break;
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeCollection that = (ShapeCollection)o;
        return this.shapes.equals(that.shapes);
    }

    @Override
    public int hashCode() {
        return this.shapes.hashCode();
    }

    @Override
    public SpatialContext getContext() {
        return this.ctx;
    }
}

