/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.StatusItem;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class TransformDefinition
extends TransformDescriptor
implements TransformSettings,
StatusItem {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_DIRTY = "dirty";
    public static final String PROP_DISCLAIMER_ACCEPTED = "disclaimerAccepted";
    public static final String PROP_INPUT_VISIBILITY_CHANGED = "inputVisibilityChanged";
    public static final String PROP_INPUT_POPUP_CHANGED = "inputPopupChanged";
    public static final String PROP_RUN_WITH_ALL = "runWithAll";
    public static final String PROP_FAVORITE = "favorite";
    private final TransformSettings _settings;
    private String _repositoryName;
    private Collection<PropertyChangeListener> _listeners;

    public TransformDefinition(TransformDescriptor descriptor, TransformSettings settings) {
        super(descriptor);
        this._settings = settings;
    }

    @Override
    public boolean isEnabled() {
        return this._settings.isEnabled();
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.isEnabled() != value) {
            this._settings.setEnabled(value);
            this.firePropertyChange(PROP_ENABLED, !value, value);
        }
    }

    @Override
    public boolean isDisclaimerAccepted() {
        return this._settings.isDisclaimerAccepted();
    }

    @Override
    public void setDisclaimerAccepted(boolean value) {
        if (this.isDisclaimerAccepted() != value) {
            this._settings.setDisclaimerAccepted(value);
            this.firePropertyChange(PROP_DISCLAIMER_ACCEPTED, !value, value);
        }
    }

    public Object getValue(PropertyDescriptor descriptor) {
        DisplayDescriptor dd;
        Object value = this._settings.getValue(descriptor);
        if (value == null && (dd = this.getProperties().get(descriptor.getName())) != null) {
            return dd.getDefaultValue();
        }
        return value;
    }

    public void setValue(PropertyDescriptor descriptor, Object value) {
        Object oldVal = this.getValue(descriptor);
        if (value != oldVal) {
            this._settings.setValue(descriptor, value);
            this.firePropertyChange(descriptor.getName(), oldVal, value);
        }
    }

    public void clear() {
        this._settings.clear();
    }

    @Override
    public Popup getPopup(PropertyDescriptor descriptor) {
        return this._settings.getPopup(descriptor);
    }

    private boolean showPopup(PropertyDescriptor descriptor, DataSource additionalValues) {
        if (descriptor.isHidden()) {
            return false;
        }
        Popup value = this._settings.getPopup(descriptor);
        if (value == Popup.Yes) {
            return true;
        }
        DisplayDescriptor dd = this.getProperties().get(descriptor.getName());
        if (dd != null) {
            return !dd.isNullable() && this.isNull(this.getValue((PropertyDescriptor)dd)) && this.isNull(additionalValues.getValue(descriptor));
        }
        return true;
    }

    public DisplayDescriptorCollection getPopupProperties(DataSource additionalValues) {
        DisplayDescriptorList popups = new DisplayDescriptorList();
        for (DisplayDescriptor dd : this.getProperties()) {
            if (dd == null || !this.showPopup((PropertyDescriptor)dd, additionalValues)) continue;
            popups.add(dd);
        }
        return popups;
    }

    @Override
    public void setPopup(PropertyDescriptor descriptor, Popup value) {
        Popup oldVal = this.getPopup(descriptor);
        if (value != oldVal) {
            this._settings.setPopup(descriptor, value);
            this.firePropertyChange(PROP_INPUT_POPUP_CHANGED, null, null);
        }
    }

    @Override
    public boolean showHelp() {
        return this._settings.showHelp();
    }

    @Override
    public void setShowHelp(boolean value) {
        this._settings.setShowHelp(value);
    }

    @Override
    public Visibility getVisibility(PropertyDescriptor descriptor) {
        Visibility value = this._settings.getVisibility(descriptor);
        return value;
    }

    @Override
    public void setVisibility(PropertyDescriptor descriptor, Visibility mode) {
        Visibility oldVal = this.getVisibility(descriptor);
        if (mode != oldVal) {
            this._settings.setVisibility(descriptor, mode);
            this.firePropertyChange(PROP_INPUT_VISIBILITY_CHANGED, null, null);
        }
    }

    @Override
    public Status getStatus() {
        if (!this.isEnabled()) {
            return Status.Disabled;
        }
        if (!StringUtilities.isNullOrEmpty((String)this.getDisclaimer()) && !this.isDisclaimerAccepted()) {
            return Status.RequiresDisclaimerAccept;
        }
        return Status.Ok;
    }

    @Override
    public String getHtmlDisplayName() {
        String colour;
        String displayName = this.getDisplayName();
        if (displayName != null) {
            displayName = displayName.replace("%", "%%");
        }
        String result = "<html><font color=\"%s\">" + displayName + "</font></html>";
        Status status = this.getStatus();
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        switch (status) {
            case Disabled: {
                colour = ColorUtilities.encode((Color)laf.getColor("7-gray-50"));
                break;
            }
            case RequiresDisclaimerAccept: {
                colour = ColorUtilities.encode((Color)laf.getColor("7-darkest-red"));
                break;
            }
            default: {
                colour = ColorUtilities.encode((Color)laf.getColor("7-black"));
            }
        }
        return String.format(result, colour);
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this._repositoryName = repositoryName;
    }

    @Override
    public boolean isRunWithAll() {
        return this._settings.isRunWithAll();
    }

    @Override
    public void setRunWithAll(boolean runWithAll) {
        if (this.isRunWithAll() != runWithAll) {
            this._settings.setRunWithAll(runWithAll);
            this.firePropertyChange(PROP_RUN_WITH_ALL, !runWithAll, runWithAll);
        }
    }

    @Override
    public boolean isFavorite() {
        return this._settings.isFavorite();
    }

    @Override
    public void setFavorite(boolean favorite) {
        if (this.isFavorite() != favorite) {
            this._settings.setFavorite(favorite);
            this.firePropertyChange(PROP_FAVORITE, !favorite, favorite);
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + super.hashCode();
        hash = 97 * hash + (this.getRepositoryName() != null ? this.getRepositoryName().hashCode() : 0);
        return hash;
    }

    public boolean equals(TransformDefinition td) {
        if (td == null) {
            return false;
        }
        return super.equals(td) && td.getRepositoryName().equals(this.getRepositoryName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TransformDefinition) {
            return this.equals((TransformDefinition)obj);
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return this._settings.isDirty();
    }

    @Override
    public void markClean() {
        boolean oldVal = this.isDirty();
        this._settings.markClean();
        boolean newVal = this.isDirty();
        if (oldVal != newVal) {
            this.firePropertyChange(PROP_DIRTY, oldVal, newVal);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this._listeners == null) {
            this._listeners = Collections.synchronizedCollection(new LinkedList());
        }
        this._listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this._listeners != null) {
            this._listeners.remove(pcl);
        }
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this._listeners != null) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, property, oldValue, newValue);
            for (PropertyChangeListener listener : this._listeners) {
                listener.propertyChange(evt);
            }
        }
    }

    private boolean isNull(Object o) {
        if (o instanceof String) {
            return StringUtilities.isNullOrEmpty((String)((String)o));
        }
        return o == null;
    }
}

