/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry;

import com.paterva.maltego.entity.api.EntitySpecSerializer;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.typing.descriptor.ToolboxItemSpec;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

class FileSystemRegistry<T extends ToolboxItemSpec> {
    private static final Logger LOG = Logger.getLogger(FileSystemRegistry.class.getName());
    private String _folderName;
    private String _extension;
    private Map<String, T> _map;
    private final Object _lock = new Object();
    private final EntitySpecSerializer _serializer = EntitySpecSerializer.getDefault();
    private FileObject _configRoot;

    public FileSystemRegistry(String folderName, String extension) {
        this(FileUtil.getConfigRoot(), folderName, extension);
    }

    public FileSystemRegistry(FileObject configRoot, String folderName, String extension) {
        this._folderName = folderName;
        this._extension = extension;
        this._configRoot = configRoot;
    }

    public Object getLock() {
        return this._lock;
    }

    private Map<String, T> map() {
        if (this._map == null) {
            this._map = this.load();
        }
        return this._map;
    }

    private String getKeyFromTypeName(String typeName) {
        return typeName == null ? typeName : typeName.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadEntities() {
        Object object = this._lock;
        synchronized (object) {
            this._map = this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String typeName) {
        Object object = this._lock;
        synchronized (object) {
            return (T)((ToolboxItemSpec)this.map().get(this.getKeyFromTypeName(typeName)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getAll() {
        Object object = this._lock;
        synchronized (object) {
            return this.map().values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T spec, String folder) {
        try {
            Object object = this._lock;
            synchronized (object) {
                this.addEntity(spec, folder);
                this.map().put(this.getKeyFromTypeName(spec.getTypeName()), spec);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String typeName) {
        Object object = this._lock;
        synchronized (object) {
            if (this.contains(typeName)) {
                try {
                    this.removeEntity(typeName);
                    this.map().remove(this.getKeyFromTypeName(typeName));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String typeName) {
        Object object = this._lock;
        synchronized (object) {
            return this.map().containsKey(this.getKeyFromTypeName(typeName));
        }
    }

    private boolean cleanupHook(String typeName) {
        if (this.getKeyFromTypeName(typeName).startsWith("maltego.affiliation.myspace_")) {
            LOG.log(Level.WARNING, "Redundant Myspace entity with prefix {0}. Deleting", new Object[]{typeName});
            return true;
        }
        return false;
    }

    private Map<String, T> load() {
        HashMap<String, T> map = new HashMap<String, T>();
        FileObject paletteFolder = this._configRoot.getFileObject(this._folderName);
        if (paletteFolder != null) {
            Enumeration categoryFolders = paletteFolder.getFolders(false);
            while (categoryFolders.hasMoreElements()) {
                FileObject categoryFolder = (FileObject)categoryFolders.nextElement();
                if ("RecentlyUsed".equals(categoryFolder.getName())) continue;
                for (FileObject entityFile : categoryFolder.getChildren()) {
                    if (entityFile.isFolder()) continue;
                    try {
                        T spec = this.loadEntity(entityFile);
                        spec.setDefaultCategory(categoryFolder.getName());
                        if (this.cleanupHook(spec.getTypeName())) {
                            entityFile.delete();
                            continue;
                        }
                        map.put(this.getKeyFromTypeName(spec.getTypeName()), spec);
                    }
                    catch (TypeInstantiationException | IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized T loadEntity(FileObject entityFile) throws FileNotFoundException, TypeInstantiationException, IOException {
        InputStream is = null;
        try {
            is = entityFile.getInputStream();
            MaltegoEntitySpec maltegoEntitySpec = this.serializer().read(is);
            return (T)maltegoEntitySpec;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private synchronized void addEntity(T spec, String folder) throws IOException, XmlSerializationException {
        String typeName;
        FileObject paletteFolder = FileUtilities.getOrCreate((String)this._folderName);
        FileObject categoryFolder = FileUtilities.getOrCreate((FileObject)paletteFolder, (String)folder);
        FileObject entityFile = categoryFolder.getFileObject(typeName = spec.getTypeName(), this._extension);
        if (entityFile == null) {
            entityFile = FileUtilities.createFreeFileObjectData((FileObject)categoryFolder, (String)typeName, (String)this._extension);
            spec.setTypeName(entityFile.getName());
        }
        this.write(entityFile, spec);
    }

    private void updateEntity(T spec) throws IOException, XmlSerializationException {
        FileObject paletteFolder = this._configRoot.getFileObject(this._folderName);
        if (paletteFolder != null) {
            Enumeration children = paletteFolder.getChildren(true);
            while (children.hasMoreElements()) {
                FileObject child = (FileObject)children.nextElement();
                if (child.isFolder() || !child.getName().equals(spec.getTypeName())) continue;
                if (!child.getParent().getName().equals(spec.getDefaultCategory())) {
                    this.removeEntity(spec.getTypeName());
                    this.addEntity(spec, spec.getDefaultCategory());
                    continue;
                }
                this.write(child, spec);
            }
        }
    }

    private void write(FileObject file, T spec) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(file.getOutputStream());){
            this.serializer().write((MaltegoEntitySpec)spec, (OutputStream)out);
        }
    }

    private void removeEntity(String typeName) throws IOException {
        FileObject paletteFolder = this._configRoot.getFileObject(this._folderName);
        if (paletteFolder != null) {
            Enumeration children = paletteFolder.getChildren(true);
            while (children.hasMoreElements()) {
                FileObject child = (FileObject)children.nextElement();
                if (child.isFolder() || !child.getName().equals(typeName)) continue;
                child.delete();
            }
        }
    }

    private EntitySpecSerializer serializer() {
        return this._serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T spec) {
        try {
            Object object = this._lock;
            synchronized (object) {
                this.updateEntity(spec);
                this.map().put(this.getKeyFromTypeName(spec.getTypeName()), spec);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String[] getFolders() {
        ArrayList<String> folders = new ArrayList<String>();
        FileObject paletteFolder = this._configRoot.getFileObject(this._folderName);
        if (paletteFolder != null) {
            Enumeration categoryFolders = paletteFolder.getFolders(false);
            while (categoryFolders.hasMoreElements()) {
                FileObject categoryFolder = (FileObject)categoryFolders.nextElement();
                folders.add(categoryFolder.getName());
            }
        }
        return folders.toArray(new String[folders.size()]);
    }
}

