/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.convert.TabularGraphImportOptions;
import com.paterva.maltego.graph.table.ui.wizard.SamplingPanel;
import com.paterva.maltego.matching.StatelessMatchingRuleDescriptor;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public class SamplingController
extends ValidatingController<SamplingPanel>
implements WizardDescriptor.ValidatingPanel {
    public static final String AUTOSAVE_NAME = "Auto-saved mapping";
    private TabularGraph _tabularGraph;

    public SamplingController() {
        this.setName("Settings");
        this.setDescription("Configure the settings used for creating the graph from the table structured file.");
        this.setBackgroundColor(new JPanel().getBackground());
    }

    protected SamplingPanel createComponent() {
        List files = (List)this.getDescriptor().getProperty("files");
        return new SamplingPanel();
    }

    public void readSettings(WizardDescriptor settings) {
        ((SamplingPanel)this.component()).setSamplingEnabled(TabularGraphImportOptions.isSamplingEnabled());
        ((SamplingPanel)this.component()).setSamplingRate(TabularGraphImportOptions.getSamplingRate());
        ((SamplingPanel)this.component()).setIgnoreBlankCells(TabularGraphImportOptions.isBlankCellsIgnored());
        ((SamplingPanel)this.component()).setTrimValues(TabularGraphImportOptions.isTrimValues());
        ((SamplingPanel)this.component()).setLimitEnabled(TabularGraphImportOptions.isEntityLimitEnabled());
        ((SamplingPanel)this.component()).setLimit(TabularGraphImportOptions.getEntityLimit());
        ((SamplingPanel)this.component()).setMergeLinks(TabularGraphImportOptions.isMergeLinks());
        ((SamplingPanel)this.component()).setNewGraph((Boolean)settings.getProperty("newGraph"));
        ((SamplingPanel)this.component()).setShowMergeOption((Boolean)settings.getProperty("showMergeGraphOption"));
        this._tabularGraph = (TabularGraph)settings.getProperty("graphTable");
        ((SamplingPanel)this.component()).setNumEntitiesAndLinks(this._tabularGraph.getEntities().size(), this._tabularGraph.getLinks().size());
        ((SamplingPanel)this.component()).setSaveMappingChecked(this.isSelectSaveCheckbox(this._tabularGraph));
        ((SamplingPanel)this.component()).setMappingName(this._tabularGraph.isExisting() ? this._tabularGraph.getName() : AUTOSAVE_NAME);
        ((SamplingPanel)this.component()).setMappingDescription(this._tabularGraph.isExisting() ? this._tabularGraph.getDescription() : this.getDefaultDescription(settings));
    }

    private boolean isSelectSaveCheckbox(TabularGraph graph) {
        return graph.isExisting() && !MappingRegistry.getDefault().get(graph.getName()).isCopyOf(graph);
    }

    protected void storeSettings(WizardDescriptor settings) {
        settings.putProperty("newGraph", (Object)((SamplingPanel)this.component()).getNewGraph());
        settings.putProperty("linkMatchingRule", TabularGraphImportOptions.isMergeLinks() ? StatelessMatchingRuleDescriptor.Default : null);
    }

    public void validate() throws WizardValidationException {
        String error = this.checkNumberAboveZero("row sampling rate", ((SamplingPanel)this.component()).getSamplingRate());
        if (error == null) {
            error = this.checkNumberAboveZero("entity limit", ((SamplingPanel)this.component()).getLimit());
        }
        if (error == null && ((SamplingPanel)this.component()).isSaveMappingChecked() && ((SamplingPanel)this.component()).getMappingName().isEmpty()) {
            error = "Please enter a non-empty name for the mapping.";
        }
        if (error == null) {
            TabularGraphImportOptions.setSamplingEnabled((boolean)((SamplingPanel)this.component()).getSamplingEnabled());
            TabularGraphImportOptions.setSamplingRate((int)Integer.parseInt(((SamplingPanel)this.component()).getSamplingRate()));
            TabularGraphImportOptions.setBlankCellsIgnored((boolean)((SamplingPanel)this.component()).getIgnoreBlankCells());
            TabularGraphImportOptions.setTrimValues((boolean)((SamplingPanel)this.component()).getTrimValues());
            TabularGraphImportOptions.setEntityLimitEnabled((boolean)((SamplingPanel)this.component()).getLimitEnabled());
            TabularGraphImportOptions.setEntityLimit((int)Integer.parseInt(((SamplingPanel)this.component()).getLimit()));
            TabularGraphImportOptions.setMergeLinks((boolean)((SamplingPanel)this.component()).getMergeLinks());
            if (((SamplingPanel)this.component()).isSaveMappingChecked()) {
                this._tabularGraph.setSavedDate(new Date());
                MappingRegistry registry = MappingRegistry.getDefault();
                this._tabularGraph.setName(((SamplingPanel)this.component()).getMappingName());
                this._tabularGraph.setDescription(((SamplingPanel)this.component()).getMappingDescription());
                registry.put(this._tabularGraph);
            } else if (!"New mapping".equals(this._tabularGraph.getName())) {
                this._tabularGraph.setSavedDate(new Date());
                MappingRegistry registry = MappingRegistry.getDefault();
                registry.put(this._tabularGraph);
            }
        }
        if (error != null) {
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
    }

    private String checkNumberAboveZero(String item, String valueStr) {
        String errorFormat = "The %s must be an integer greater than 0";
        String error = null;
        try {
            int value = Integer.parseInt(valueStr);
            if (value <= 0) {
                error = String.format("The %s must be an integer greater than 0", item);
            }
        }
        catch (NumberFormatException ex) {
            error = String.format("The %s must be an integer greater than 0", item);
        }
        return error;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    private String getDefaultDescription(WizardDescriptor settings) {
        List files = (List)this.getDescriptor().getProperty("files");
        return "Source: " + ((File)files.get(0)).getName();
    }
}

