/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.test;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.transform.api.JavaTransform;
import com.paterva.maltego.transform.api.TransformContext;
import com.paterva.maltego.transform.api.TransformException;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.api.TransformAdapter;
import com.paterva.maltego.transform.runner.api.TransformCallback;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformRunRestrictedException;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.ui.graph.GraphCopyHelper;
import com.paterva.maltego.util.Args;
import java.util.Date;
import java.util.Map;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class JavaTransformAdapter
implements TransformAdapter {
    private static final PropertyDescriptor TRANSFORM = new PropertyDescriptor(String.class, "maltego.transform.java-class-name");
    private boolean _cancelled = false;

    public void run(TransformRunContext context) throws TransformRunRestrictedException {
        if (!A.C()) {
            throw TransformRunRestrictedException.forLocal();
        }
        Args.notNull((Object)context, (String)"context");
        TransformCallback cb = context.getCallback();
        try {
            DataSource transformInputs = context.getTransformInputs();
            GraphID graphID = context.getTargetGraphID();
            Map inputEntities = context.getInputEntities();
            String className = (String)transformInputs.getValue(TRANSFORM);
            JavaTransform transform = this.createTransform(className);
            TransformTask task = new TransformTask(transform, graphID, transformInputs, cb, inputEntities);
            task.run();
        }
        catch (TransformException ex) {
            ex.printStackTrace();
            cb.resultReceived(TransformResult.error((Exception)((Object)ex)));
        }
    }

    public void cancel() {
        this._cancelled = true;
    }

    private JavaTransform createTransform(String className) throws TransformException {
        try {
            if (className == null) {
                throw new TransformException("The transform property \"maltego.transform.java-class-name\" cannot be null.");
            }
            className = className.trim();
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = loader.loadClass(className);
            if (clazz == null) {
                throw new TransformException("The transform class \"" + className + "\" could not be found.");
            }
            Object instance = clazz.newInstance();
            if (instance instanceof JavaTransform) {
                return (JavaTransform)instance;
            }
            throw new TransformException("The transform class \"" + className + "\" is not an instance of " + JavaTransform.class.getName());
        }
        catch (InstantiationException ex) {
            throw new TransformException("The transform class \"" + className + "\" could not be instantiated.", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new TransformException("The transform class \"" + className + "\" could not be instantiated.", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new TransformException("The transform class \"" + className + "\" could not be found.", (Throwable)ex);
        }
    }

    private class TransformTask
    implements TransformContext {
        private JavaTransform _transform;
        private DataSource _transformInputs;
        private TransformCallback _cb;
        private GraphID _targetGraphID;
        private Map<EntityID, MaltegoEntity> _inputEntities;
        private GraphID _resultGraphID;

        public TransformTask(JavaTransform transform, GraphID graphID, DataSource transformInputs, TransformCallback cb, Map<EntityID, MaltegoEntity> inputEntities) {
            this._transform = transform;
            this._transformInputs = transformInputs;
            this._cb = cb;
            this._targetGraphID = graphID;
            this._inputEntities = inputEntities;
        }

        public void run() {
            try {
                this._resultGraphID = GraphCopyHelper.copy((GraphID)this._targetGraphID, this._inputEntities.keySet(), (boolean)true, (boolean)true);
                this._transform.transform(this._resultGraphID, (TransformContext)this);
                this._cb.resultReceived(TransformResult.progress(null, (int)100, (GraphID)this._resultGraphID, (int)0, (boolean)true, null));
            }
            catch (GraphStoreException | TransformException ex) {
                ex.printStackTrace();
                this.error((Exception)ex);
            }
        }

        public void updateProgress(String msg) {
            this.updateProgress(msg, -1);
        }

        public void updateProgress(String msg, int percent) {
            this.updateProgress(msg, percent, false);
        }

        public void updateProgress(int percent) {
            this.updateProgress(null, percent);
        }

        public void updateProgress(String msg, boolean updateGraph) {
            this.updateProgress(msg, -1, updateGraph);
        }

        public void updateProgress(String msg, int percent, boolean updateGraph) {
            int entityCount = 0;
            if (updateGraph) {
                try {
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._resultGraphID);
                    entityCount = graphStore.getGraphStructureStore().getStructureReader().getEntityCount();
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this._cb.resultReceived(TransformResult.progress((String)msg, (int)percent, (GraphID)this._resultGraphID, (int)entityCount, (boolean)false, null));
        }

        public void updateProgress(int percent, boolean updateGraph) {
            this.updateProgress(null, percent, updateGraph);
        }

        public void log(String message, TransformMessage.Severity severity) {
            this._cb.resultReceived(TransformResult.message((TransformMessage)new TransformMessage(new Date(), severity, message)));
        }

        private void error(Exception ex) {
            this._cb.resultReceived(TransformResult.error((Exception)ex));
        }

        public boolean isCancelled() {
            return JavaTransformAdapter.this._cancelled;
        }

        public Object getInput(String name) {
            return this._transformInputs.getValue(new PropertyDescriptor(Object.class, name));
        }

        public <T> T getInput(String name, T defaultValue) {
            Object value = this.getInput(name);
            if (value == null) {
                return defaultValue;
            }
            return (T)value;
        }
    }
}

