/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.ViewGraphName;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.I.M;
import yguard.A.I.R;
import yguard.A.J.SA;

public class GraphPositionAndPathHelper {
    private static final String MAIN_VIEW = "Main";

    private GraphPositionAndPathHelper() {
    }

    public static Map<String, Map<EntityID, Point>> getAllCenters(GraphID graphID, Set<EntityID> entityIDs) {
        HashMap<String, Map<EntityID, Point>> centers = new HashMap<String, Map<EntityID, Point>>();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphLayoutReader layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
            centers.put(MAIN_VIEW, layoutReader.getCenters(entityIDs));
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return centers;
    }

    public static Map<String, Map<EntityID, Point>> getAllCenters(D modelGraph, Set<EntityID> entityIDs) {
        HashMap<String, Map<EntityID, Point>> centers = new HashMap<String, Map<EntityID, Point>>();
        Map<String, D> viewNames = ViewGraphName.getForModelGraph(modelGraph);
        for (Map.Entry<String, D> entrySet : viewNames.entrySet()) {
            centers.put(entrySet.getKey(), GraphPositionAndPathHelper.getViewCenters((SA)entrySet.getValue(), entityIDs));
        }
        return centers;
    }

    public static Map<String, Map<LinkID, List<Point>>> getAllPaths(GraphID graphID, Set<LinkID> linkIDs) {
        HashMap<String, Map<LinkID, List<Point>>> paths = new HashMap<String, Map<LinkID, List<Point>>>();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphLayoutReader layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
            paths.put(MAIN_VIEW, layoutReader.getPaths(linkIDs));
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return paths;
    }

    public static Map<String, Map<LinkID, List<Point>>> getAllPaths(D modelGraph, Set<LinkID> linkIDs) {
        HashMap<String, Map<LinkID, List<Point>>> paths = new HashMap<String, Map<LinkID, List<Point>>>();
        Set<D> viewGraphs = Collections.singleton(modelGraph);
        if (viewGraphs != null) {
            for (D viewGraph : viewGraphs) {
                String viewName = ViewGraphName.get(viewGraph);
                if (viewName == null) continue;
                paths.put(viewName, GraphPositionAndPathHelper.getViewPaths((SA)viewGraph, linkIDs));
            }
        }
        return paths;
    }

    public static Map<LinkID, List<Point>> getViewPathsForEntities(SA viewGraph, Set<EntityID> entityIDs) {
        Set<LinkID> linkIDs = GraphTransactionHelper.getLinkIDs((D)viewGraph, entityIDs);
        return GraphPositionAndPathHelper.getViewPaths(viewGraph, linkIDs);
    }

    public static Map<LinkID, List<Point>> getViewPaths(SA viewGraph, Set<LinkID> linkIDs) {
        HashMap<LinkID, List<Point>> paths = new HashMap<LinkID, List<Point>>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)viewGraph);
        for (LinkID linkID : linkIDs) {
            H edge = wrapper.edge(linkID);
            if (edge == null) continue;
            paths.put(linkID, GraphPositionAndPathHelper.getPath(viewGraph, edge));
        }
        return paths;
    }

    public static List<Point> getPath(SA viewGraph, H edge) {
        R pointPath = viewGraph.T(edge);
        List<Point> path = GraphPositionAndPathHelper.yPointPathToList(pointPath);
        M sourcePointRel = viewGraph.N(edge);
        M targetPointRel = viewGraph.U(edge);
        GraphPositionAndPathHelper.replaceSourceAndTargetPoints(path, sourcePointRel, targetPointRel);
        return path;
    }

    public static void replaceSourceAndTargetPoints(List<Point> path, M sourcePointRel, M targetPointRel) {
        path.set(0, new Point((int)sourcePointRel.A, (int)sourcePointRel.D));
        path.set(path.size() - 1, new Point((int)targetPointRel.A, (int)targetPointRel.D));
    }

    public static List<Point> yPointPathToList(R pointPath) {
        ArrayList<Point> path = new ArrayList<Point>();
        Iterator itr = pointPath.E();
        while (itr.hasNext()) {
            M point = (M)itr.next();
            path.add(new Point((int)point.A, (int)point.D));
        }
        return path;
    }

    public static R listToYPointPath(List<Point> path) {
        ArrayList<M> pointList = new ArrayList<M>(path.size());
        for (Point point2D : path) {
            pointList.add(new M((double)point2D.x, (double)point2D.y));
        }
        return new R(pointList);
    }

    public static Map<EntityID, Point> getViewCenters(SA viewGraph, Set<EntityID> entityIDs) {
        HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>(entityIDs.size());
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)viewGraph);
        for (EntityID entityID : entityIDs) {
            Y node = wrapper.node(entityID);
            if (node == null) continue;
            double x2 = viewGraph.S(node);
            double y2 = viewGraph.O(node);
            centers.put(entityID, new Point((int)x2, (int)y2));
        }
        return centers;
    }

    public static Map<String, Map<EntityID, Point>> setAllCenters(GraphID graphID, GraphTransaction transaction) {
        HashMap<String, Map<EntityID, Point>> inverse = new HashMap<String, Map<EntityID, Point>>();
        String graphName = MAIN_VIEW;
        Set<String> views = transaction.getViews();
        try {
            if (views.contains(MAIN_VIEW)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphLayoutStore layoutStore = graphStore.getGraphLayoutStore();
                GraphLayoutReader layoutReader = layoutStore.getLayoutReader();
                GraphLayoutWriter layoutWriter = layoutStore.getLayoutWriter();
                HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>();
                for (EntityID entityID : transaction.getEntityIDs()) {
                    Point center = transaction.getCenter(MAIN_VIEW, entityID);
                    if (center == null) continue;
                    centers.put(entityID, center);
                }
                if (!centers.isEmpty()) {
                    if (!GraphOperation.Add.equals((Object)transaction.getOperation())) {
                        Map inverseCenters = layoutReader.getCenters(centers.keySet());
                        inverse.put(MAIN_VIEW, inverseCenters);
                    }
                    layoutWriter.setCenters(centers);
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return inverse;
    }

    public static Map<String, Map<EntityID, Point>> setAllCentersOld(D modelGraph, GraphTransaction transaction) {
        HashMap<String, Map<EntityID, Point>> inverse = new HashMap<String, Map<EntityID, Point>>();
        Set<D> viewGraphs = Collections.singleton(modelGraph);
        if (viewGraphs != null) {
            Set<String> views = transaction.getViews();
            for (D viewGraph : viewGraphs) {
                SA viewGraph2D = (SA)viewGraph;
                String graphName = ViewGraphName.get((D)viewGraph2D);
                if (!views.contains(graphName)) continue;
                HashMap<EntityID, Point> inverseCenters = new HashMap<EntityID, Point>();
                for (EntityID entityID : transaction.getEntityIDs()) {
                    GraphWrapper viewWrapper;
                    Y node;
                    Point center = transaction.getCenter(graphName, entityID);
                    if (center == null || (node = (viewWrapper = MaltegoGraphManager.getWrapper((D)viewGraph2D)).node(entityID)) == null) continue;
                    M location = viewGraph2D.R(node);
                    inverseCenters.put(entityID, new Point((int)location.A, (int)location.D));
                    viewGraph2D.D(node, (double)center.x, (double)center.y);
                }
                inverse.put(graphName, inverseCenters);
            }
        }
        return inverse;
    }

    public static Map<String, Map<LinkID, List<Point>>> setAllPaths(GraphID graphID, GraphTransaction transaction) {
        HashMap<String, Map<LinkID, List<Point>>> inverse = new HashMap<String, Map<LinkID, List<Point>>>();
        String graphName = MAIN_VIEW;
        Set<String> views = transaction.getViews();
        try {
            if (views.contains(MAIN_VIEW)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphLayoutStore layoutStore = graphStore.getGraphLayoutStore();
                GraphLayoutReader layoutReader = layoutStore.getLayoutReader();
                GraphLayoutWriter layoutWriter = layoutStore.getLayoutWriter();
                HashMap<LinkID, List<Point>> paths = new HashMap<LinkID, List<Point>>();
                for (LinkID linkID : transaction.getLinkIDs()) {
                    List<Point> path = transaction.getPath(MAIN_VIEW, linkID);
                    if (path == null) continue;
                    paths.put(linkID, path);
                }
                if (!paths.isEmpty()) {
                    if (!GraphOperation.Add.equals((Object)transaction.getOperation())) {
                        Map inverseCenters = layoutReader.getPaths(paths.keySet());
                        inverse.put(MAIN_VIEW, inverseCenters);
                    }
                    layoutWriter.setPaths(paths);
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return inverse;
    }

    public static Map<String, Map<LinkID, List<Point>>> setAllPathsOld(D modelGraph, GraphTransaction transaction) {
        HashMap<String, Map<LinkID, List<Point>>> inverse = new HashMap<String, Map<LinkID, List<Point>>>();
        Set<D> viewGraphs = Collections.singleton(modelGraph);
        if (viewGraphs != null) {
            Set<String> views = transaction.getViews();
            for (D viewGraph : viewGraphs) {
                SA viewGraph2D = (SA)viewGraph;
                String graphName = ViewGraphName.get((D)viewGraph2D);
                if (!views.contains(graphName)) continue;
                HashMap<LinkID, List<Point>> inversePaths = new HashMap<LinkID, List<Point>>();
                for (LinkID linkID : transaction.getLinkIDs()) {
                    GraphWrapper viewWrapper;
                    H edge;
                    List<Point> path = transaction.getPath(graphName, linkID);
                    if (path == null || (edge = (viewWrapper = MaltegoGraphManager.getWrapper((D)viewGraph2D)).edge(linkID)) == null) continue;
                    List<Point> pathBefore = GraphPositionAndPathHelper.getPath(viewGraph2D, edge);
                    inversePaths.put(linkID, pathBefore);
                    R pointPath = GraphPositionAndPathHelper.listToYPointPath(path);
                    viewGraph2D.A(edge, pointPath);
                    viewGraph2D.A(edge, pointPath.L());
                    viewGraph2D.C(edge, pointPath.I());
                }
                inverse.put(graphName, inversePaths);
            }
        }
        return inverse;
    }

    public static void removeCentersForMissingEntities(Map<EntityID, Point> centers, Set<EntityID> entityIDs) {
        Iterator<Map.Entry<EntityID, Point>> itr = centers.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<EntityID, Point> center = itr.next();
            EntityID guid = center.getKey();
            if (entityIDs.contains(guid)) continue;
            itr.remove();
        }
    }

    public static void removePathsForMissingLinks(Map<LinkID, List<Point>> paths, Set<LinkID> linkIDs) {
        Iterator<Map.Entry<LinkID, List<Point>>> itr = paths.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<LinkID, List<Point>> path = itr.next();
            LinkID guid = path.getKey();
            if (linkIDs.contains(guid)) continue;
            itr.remove();
        }
    }

    public static void removeUnchangedCenters(Map<EntityID, Point> before, Map<EntityID, Point> after) {
        ArrayList<EntityID> toRemove = new ArrayList<EntityID>();
        for (Map.Entry<EntityID, Point> entry : before.entrySet()) {
            Point afterValue;
            EntityID guid = entry.getKey();
            Point beforeValue = entry.getValue();
            if (!GraphPositionAndPathHelper.compare(beforeValue, afterValue = after.get(guid))) continue;
            toRemove.add(guid);
        }
        for (EntityID guid : toRemove) {
            before.remove(guid);
            after.remove(guid);
        }
    }

    public static void removeUnchangedPaths(Map<LinkID, List<Point>> before, Map<LinkID, List<Point>> after) {
        ArrayList<LinkID> toRemove = new ArrayList<LinkID>();
        for (Map.Entry<LinkID, List<Point>> entry : before.entrySet()) {
            LinkID guid = entry.getKey();
            List<Point> beforePath = entry.getValue();
            List<Point> afterPath = after.get(guid);
            if (beforePath.size() != afterPath.size()) continue;
            Iterator<Point> beforeItr = beforePath.iterator();
            Iterator<Point> afterItr = afterPath.iterator();
            boolean same = true;
            while (beforeItr.hasNext()) {
                Point afterValue;
                Point beforeValue = beforeItr.next();
                if (GraphPositionAndPathHelper.compare(beforeValue, afterValue = afterItr.next())) continue;
                same = false;
                break;
            }
            if (!same) continue;
            toRemove.add(guid);
        }
        for (LinkID guid : toRemove) {
            before.remove(guid);
            after.remove(guid);
        }
    }

    private static boolean compare(Point left, Point right) {
        return GraphPositionAndPathHelper.compare(left.x, right.x) && GraphPositionAndPathHelper.compare(left.y, right.y);
    }

    private static boolean compare(int left, int right) {
        return Math.abs(left - right) <= 1;
    }

    public static Map<String, Map<EntityID, Point>> getCenters(GraphTransaction transaction) {
        HashMap<String, Map<EntityID, Point>> centers = new HashMap<String, Map<EntityID, Point>>();
        Set<String> views = transaction.getViews();
        Set<EntityID> entityIDs = transaction.getEntityIDs();
        for (String view : views) {
            HashMap<EntityID, Point> points = new HashMap<EntityID, Point>();
            for (EntityID entityID : entityIDs) {
                Point center = transaction.getCenter(view, entityID);
                if (center == null) continue;
                points.put(entityID, center);
            }
            if (points.isEmpty()) continue;
            centers.put(view, points);
        }
        return centers;
    }

    public static Map<String, Map<LinkID, List<Point>>> getPaths(GraphTransaction transaction) {
        HashMap<String, Map<LinkID, List<Point>>> pathss = new HashMap<String, Map<LinkID, List<Point>>>();
        Set<String> views = transaction.getViews();
        Set<LinkID> linkIDs = transaction.getLinkIDs();
        for (String view : views) {
            HashMap<LinkID, List<Point>> paths = new HashMap<LinkID, List<Point>>();
            for (LinkID linkID : linkIDs) {
                List<Point> path = transaction.getPath(view, linkID);
                if (path == null) continue;
                paths.put(linkID, path);
            }
            if (paths.isEmpty()) continue;
            pathss.put(view, paths);
        }
        return pathss;
    }
}

