/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class HoverContext {
    public static final String CONTEXT_ID_GLOBAL = "global";
    public static final String CONTEXT_ID_GRAPH = "graph";
    public static final String PROP_HOVER_VIEW_CHANGED = "hoverViewChanged";
    public static final String PROP_HOVER_MODEL_CHANGED = "hoverModelChanged";
    public static final String PROP_HOVER_CHANGED = "hoverChanged";
    private static final Logger LOG = Logger.getLogger(HoverContext.class.getName());
    private static final Map<String, HoverContext> _instances = new HashMap<String, HoverContext>(2);
    private final String _contextID;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final PropertyChangeListener _viewListener = new ViewListener();
    private final PropertyChangeListener _modelListener = new ModelListener();
    private GraphPart<? extends Guid> _hoverViewPart;
    private GraphPart<? extends Guid> _hoverModelPart;
    private GraphStructureStore _viewStructureStore;
    private GraphStructureStore _modelStructureStore;

    public static synchronized HoverContext forContextID(String contextID) {
        HoverContext context = _instances.get(contextID);
        if (context == null) {
            context = new HoverContext(contextID);
            _instances.put(contextID, context);
        }
        return context;
    }

    public HoverContext(String contextID) {
        this._contextID = contextID;
    }

    public GraphPart<? extends Guid> getHoverPart() {
        GraphPart<? extends Guid> part = this.getHoverModelPart();
        if (part == null) {
            part = this.getHoverViewPart();
        }
        LOG.log(Level.FINE, "{0}: Get part: {1}", new Object[]{this._contextID, part});
        return part;
    }

    public GraphPart<? extends Guid> getHoverViewPart() {
        LOG.log(Level.FINE, "{0}: Get view part: {1}", new Object[]{this._contextID, this._hoverViewPart});
        return this._hoverViewPart;
    }

    public GraphPart<? extends Guid> getHoverModelPart() {
        LOG.log(Level.FINE, "{0}: Get model part: {1}", new Object[]{this._contextID, this._hoverModelPart});
        return this._hoverModelPart;
    }

    public void setHoverViewPart(GraphPart<? extends Guid> viewPart) {
        if (!Utilities.compareObjects(this._hoverViewPart, viewPart)) {
            LOG.log(Level.FINE, "{0}: Set view part: {1}", new Object[]{this._contextID, viewPart});
            this.removeViewListener();
            GraphPart<? extends Guid> oldViewPart = this._hoverViewPart;
            GraphPart<? extends Guid> hoverPartBefore = this.getHoverPart();
            this._hoverViewPart = viewPart;
            this.addViewListener(this._hoverViewPart);
            GraphPart<? extends Guid> hoverPartAfter = this.getHoverPart();
            this.firePropertyChange(PROP_HOVER_VIEW_CHANGED, oldViewPart, this._hoverViewPart);
            if (!Utilities.compareObjects(hoverPartBefore, hoverPartAfter)) {
                this.firePropertyChange(PROP_HOVER_CHANGED, hoverPartBefore, hoverPartAfter);
            }
        }
    }

    public void setHoverModelPart(GraphPart<? extends Guid> modelPart) {
        if (!Utilities.compareObjects(this._hoverModelPart, modelPart)) {
            LOG.log(Level.FINE, "{0}: Set model part: {1}", new Object[]{this._contextID, modelPart});
            this.removeModelListener();
            GraphPart<? extends Guid> oldModelPart = this._hoverModelPart;
            GraphPart<? extends Guid> hoverPartBefore = this.getHoverPart();
            this._hoverModelPart = modelPart;
            this.addModelListener(this._hoverModelPart);
            GraphPart<? extends Guid> hoverPartAfter = this.getHoverPart();
            this.firePropertyChange(PROP_HOVER_MODEL_CHANGED, oldModelPart, this._hoverModelPart);
            if (!Utilities.compareObjects(hoverPartBefore, hoverPartAfter)) {
                this.firePropertyChange(PROP_HOVER_CHANGED, hoverPartBefore, hoverPartAfter);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private void firePropertyChange(String prop, GraphPart<? extends Guid> before, GraphPart<? extends Guid> after) {
        LOG.log(Level.FINE, "{0}: {1}: before={2} after={3}", new Object[]{this._contextID, prop, before, after});
        this._changeSupport.firePropertyChange(prop, before, after);
    }

    private void addViewListener(GraphPart<? extends Guid> viewPart) {
        if (viewPart != null) {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(viewPart.getGraphID());
            this._viewStructureStore = view.getGraphStructureStore();
            this._viewStructureStore.addPropertyChangeListener(this._viewListener);
        }
    }

    private void removeViewListener() {
        if (this._viewStructureStore != null) {
            this._viewStructureStore.removePropertyChangeListener(this._viewListener);
            this._viewStructureStore = null;
        }
    }

    private void addModelListener(GraphPart<? extends Guid> modelPart) {
        try {
            if (modelPart != null) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(modelPart.getGraphID());
                this._modelStructureStore = graphStore.getGraphStructureStore();
                this._modelStructureStore.addPropertyChangeListener(this._modelListener);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void removeModelListener() {
        if (this._modelStructureStore != null) {
            this._modelStructureStore.removePropertyChangeListener(this._modelListener);
            this._modelStructureStore = null;
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Guid partID;
            GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
            if (HoverContext.this._hoverModelPart != null && ((partID = HoverContext.this._hoverModelPart.getID()) instanceof EntityID && mods.getEntitiesRemoved().contains((EntityID)partID) || partID instanceof LinkID && mods.getLinksRemoved().containsKey((LinkID)partID))) {
                HoverContext.this.setHoverModelPart(null);
            }
        }
    }

    private class ViewListener
    implements PropertyChangeListener {
        private ViewListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
            Guid partID = HoverContext.this._hoverViewPart.getID();
            if (partID instanceof EntityID && mods.getEntitiesRemoved().contains((EntityID)partID) || partID instanceof LinkID && mods.getLinksRemoved().containsKey((LinkID)partID)) {
                HoverContext.this.setHoverViewPart(null);
            }
        }
    }
}

