/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactoryapi;

import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.util.Args;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class RegistryIcon
implements Comparable<RegistryIcon> {
    private final String category;
    private final String name;
    private final Set<String> aliases;
    private final Set<String> hubItems;
    private BufferedImage cachedImage = null;

    RegistryIcon(String category, String name, Set<String> aliases, Set<String> hubItems) {
        Args.notNullOrBlank((String)category, (String)"category");
        Args.notNullOrBlank((String)name, (String)"name");
        Args.notNull(aliases, (String)"aliases");
        Args.notNull(hubItems, (String)"hubItems");
        this.category = category;
        this.name = name;
        this.aliases = Collections.unmodifiableSet(new LinkedHashSet<String>(aliases));
        this.hubItems = Collections.unmodifiableSet(new LinkedHashSet<String>(hubItems));
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Set<String> getHubItems() {
        return this.hubItems;
    }

    BufferedImage getCachedImage() {
        return this.cachedImage;
    }

    void setCachedImage(BufferedImage cacheImage) {
        this.cachedImage = cacheImage;
    }

    public VirtualIcon toVirualIcon() {
        return new VirtualIcon(this.category, this.name);
    }

    @Override
    public int compareTo(RegistryIcon o) {
        if (o == null) {
            return 1;
        }
        int result = this.getCategory().compareToIgnoreCase(o.getCategory());
        return result != 0 ? result : this.getName().compareToIgnoreCase(o.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.category) + Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegistryIcon other = (RegistryIcon)obj;
        return Objects.equals(this.category, other.category) && Objects.equals(this.name, other.name);
    }
}

