/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.undo;

import com.paterva.maltego.graph.undo.Bundle;
import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.IndexedCommand;
import com.paterva.maltego.graph.undo.UndoRedoCommandMerger;
import com.paterva.maltego.graph.undo.UndoRedoExecutor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

public class UndoRedoModel {
    private static final Logger LOG = Logger.getLogger(UndoRedoModel.class.getName());
    private static final int UNDO_DEPTH = Integer.decode(Bundle.UndoDepth());
    private Deque<IndexedCommand> _undoStack = new ArrayDeque<IndexedCommand>();
    private Deque<IndexedCommand> _redoStack = new ArrayDeque<IndexedCommand>();
    private final ChangeSupport _undoChangeSupport = new ChangeSupport((Object)this);
    private int _highestIndex = -1;

    public void store(Command cmd) {
        this._redoStack.clear();
        this.addToUndo(new IndexedCommand(cmd));
        this._undoChangeSupport.fireChange();
    }

    public void store(Command cmd, Integer index) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("--Before--");
            this.printStacks();
        }
        if (this.tryMerge(cmd, index)) {
            this._redoStack.clear();
            if (index > this._highestIndex) {
                this._highestIndex = index;
            }
        } else {
            IndexedCommand commandToStore = new IndexedCommand(cmd, index);
            if (index == null) {
                this.store(cmd);
            } else if (index > this._highestIndex) {
                this._redoStack.clear();
                this.addToUndo(commandToStore);
                this._highestIndex = index;
            } else {
                Deque<IndexedCommand> stack = this.tryInsert(this.reverse(this._undoStack), commandToStore);
                if (stack != null) {
                    this._undoStack = this.reverse(stack);
                    if (this._undoStack.peekFirst() == commandToStore) {
                        this._redoStack.clear();
                    }
                    while (this.getSignificantUndoDepth() > UNDO_DEPTH) {
                        this._undoStack.removeLast();
                    }
                } else {
                    stack = this.tryInsert(this._redoStack, commandToStore);
                    if (stack != null) {
                        this._redoStack = stack;
                    }
                }
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("--After--");
            this.printStacks();
        }
        this._undoChangeSupport.fireChange();
    }

    private boolean tryMerge(Command cmd, Integer index) {
        for (UndoRedoCommandMerger merger : Lookup.getDefault().lookupAll(UndoRedoCommandMerger.class)) {
            if (!merger.merge(this._undoStack, cmd, index)) continue;
            return true;
        }
        return false;
    }

    private Deque<IndexedCommand> tryInsert(Deque<IndexedCommand> stack, IndexedCommand commandToInsert) {
        boolean inserted = false;
        boolean mustInsert = false;
        int previousIndex = commandToInsert.getIndex() - 1;
        ArrayDeque<IndexedCommand> temporaryStack = new ArrayDeque<IndexedCommand>();
        for (IndexedCommand indexedCommand : stack) {
            Integer cmdIndex = indexedCommand.getIndex();
            if (!inserted && mustInsert && cmdIndex != null && !cmdIndex.equals(commandToInsert.getIndex())) {
                temporaryStack.add(commandToInsert);
                inserted = true;
            }
            temporaryStack.add(indexedCommand);
            if (inserted || mustInsert || cmdIndex == null || previousIndex != cmdIndex) continue;
            mustInsert = true;
        }
        if (!inserted && mustInsert) {
            temporaryStack.add(commandToInsert);
            inserted = true;
        }
        return inserted ? temporaryStack : null;
    }

    private Deque<IndexedCommand> reverse(Deque<IndexedCommand> stack) {
        ArrayList<IndexedCommand> tempList = new ArrayList<IndexedCommand>(stack);
        Collections.reverse(tempList);
        return new ArrayDeque<IndexedCommand>(tempList);
    }

    private void addToUndo(IndexedCommand cmd) {
        this._undoStack.push(cmd);
        while (this.getSignificantUndoDepth() > UNDO_DEPTH) {
            this._undoStack.removeLast();
        }
    }

    public boolean canUndo() {
        return this.getSignificantUndoDepth() > 0;
    }

    public boolean canRedo() {
        return this.getSignificantRedoDepth() > 0;
    }

    public void undo() throws CannotUndoException {
        boolean isDone = false;
        while (!isDone) {
            IndexedCommand command = this.popUndoCommand();
            this._redoStack.push(command);
            boolean significant = command.getCommand().isSignificant();
            UndoRedoExecutor.getDefault().undo(command.getCommand());
            isDone = this._undoStack.isEmpty() || significant;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("--After Undo--");
            this.printStacks();
        }
        this._undoChangeSupport.fireChange();
    }

    private IndexedCommand popUndoCommand() {
        return this._undoStack.pop();
    }

    public void redo() throws CannotRedoException {
        boolean isDone = false;
        while (!isDone) {
            IndexedCommand command = this._redoStack.pop();
            this.addToUndo(command);
            UndoRedoExecutor.getDefault().redo(command.getCommand());
            isDone = this._redoStack.isEmpty() || this._redoStack.peekFirst().getCommand().isSignificant();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("--After Redo--");
            this.printStacks();
        }
        this._undoChangeSupport.fireChange();
    }

    protected int getSignificantUndoDepth() {
        return this.getSignificantDepth(this._undoStack);
    }

    protected int getSignificantRedoDepth() {
        return this.getSignificantDepth(this._redoStack);
    }

    private int getSignificantDepth(Deque<IndexedCommand> commands) {
        int depth = 0;
        for (IndexedCommand cmd : commands) {
            if (!cmd.getCommand().isSignificant()) continue;
            ++depth;
        }
        return depth;
    }

    public void addChangeListener(ChangeListener l) {
        this._undoChangeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._undoChangeSupport.removeChangeListener(l);
    }

    public Command[] getUndoStack() {
        return this.getCommandArray(this._undoStack);
    }

    public Command[] getRedoStack() {
        return this.getCommandArray(this._redoStack);
    }

    private Command[] getCommandArray(Deque<IndexedCommand> commands) {
        Command[] cmdArray = new Command[commands.size()];
        int num = 0;
        for (IndexedCommand indexedCmd : commands) {
            cmdArray[num++] = indexedCmd.getCommand();
        }
        return cmdArray;
    }

    private void printStacks() {
        LOG.fine("-=<UNDO>=-");
        for (IndexedCommand cmd : this._undoStack) {
            LOG.log(Level.FINE, "{0} -> {1}", new Object[]{cmd.getIndex(), cmd.getCommand()});
        }
        LOG.fine("-=<REDO>=-");
        for (IndexedCommand cmd : this._redoStack) {
            LOG.log(Level.FINE, "{0} -> {1}", new Object[]{cmd.getIndex(), cmd.getCommand()});
        }
    }
}

