/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.base;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.base.Environment;
import org.netbeans.modules.extexecution.base.ExternalProcessBuilder;
import org.netbeans.modules.extexecution.base.ProcessBuilderAccessor;
import org.netbeans.modules.extexecution.base.ProcessParametersAccessor;
import org.netbeans.spi.extexecution.base.EnvironmentFactory;
import org.netbeans.spi.extexecution.base.EnvironmentImplementation;
import org.netbeans.spi.extexecution.base.ProcessBuilderImplementation;
import org.netbeans.spi.extexecution.base.ProcessParameters;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class ProcessBuilder
implements Callable<Process>,
Lookup.Provider {
    private final ProcessBuilderImplementation implementation;
    private final Object lock;
    private final String description;
    private String executable;
    private String workingDirectory;
    private final List<String> arguments = new ArrayList<String>();
    private boolean redirectErrorStream;

    private ProcessBuilder(ProcessBuilderImplementation implementation2, String description) {
        assert (implementation2 != null);
        this.implementation = implementation2;
        this.description = description;
        this.lock = implementation2;
    }

    public static ProcessBuilder getLocal() {
        return new ProcessBuilder(new LocalProcessBuilder(), NbBundle.getMessage(ProcessBuilder.class, (String)"LocalProcessBuilder"));
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecutable(@NonNull String executable) {
        Parameters.notNull((CharSequence)"executable", (Object)executable);
        Object object = this.lock;
        synchronized (object) {
            this.executable = executable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkingDirectory(@NullAllowed String workingDirectory) {
        Object object = this.lock;
        synchronized (object) {
            this.workingDirectory = workingDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArguments(@NonNull List<String> arguments) {
        Parameters.notNull((CharSequence)"arguments", arguments);
        Object object = this.lock;
        synchronized (object) {
            this.arguments.clear();
            this.arguments.addAll(arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedirectErrorStream(boolean redirectErrorStream) {
        Object object = this.lock;
        synchronized (object) {
            this.redirectErrorStream = redirectErrorStream;
        }
    }

    @NonNull
    public Environment getEnvironment() {
        return this.implementation.getEnvironment();
    }

    public Lookup getLookup() {
        if (this.implementation != null) {
            return this.implementation.getLookup();
        }
        return Lookup.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Process call() throws IOException {
        boolean currentRedirectErrorStream;
        String currentWorkingDirectory;
        String currentExecutable;
        ArrayList<String> currentArguments = new ArrayList<String>();
        HashMap<String, String> currentVariables = new HashMap<String, String>();
        Object object = this.lock;
        synchronized (object) {
            currentExecutable = this.executable;
            currentWorkingDirectory = this.workingDirectory;
            currentArguments.addAll(this.arguments);
            currentRedirectErrorStream = this.redirectErrorStream;
            currentVariables.putAll(this.getEnvironment().values());
        }
        if (currentExecutable == null) {
            throw new IllegalStateException("The executable has not been configured");
        }
        ProcessParameters params = ProcessParametersAccessor.getDefault().createProcessParameters(currentExecutable, currentWorkingDirectory, currentArguments, currentRedirectErrorStream, currentVariables);
        return this.implementation.createProcess(params);
    }

    static {
        ProcessBuilderAccessor.setDefault(new ProcessBuilderAccessor(){

            @Override
            public ProcessBuilder createProcessBuilder(ProcessBuilderImplementation impl, String description) {
                return new ProcessBuilder(impl, description);
            }
        });
    }

    private static class LocalEnvironment
    implements EnvironmentImplementation {
        private final LocalProcessBuilder builder;
        private final Map<String, String> systemEnvironment;
        private final String pathName;

        public LocalEnvironment(LocalProcessBuilder builder, Map<String, String> systemEnvironment) {
            this.builder = builder;
            this.systemEnvironment = new HashMap<String, String>(systemEnvironment);
            this.pathName = ExternalProcessBuilder.getPathName(systemEnvironment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getVariable(String name) {
            LocalProcessBuilder localProcessBuilder = this.builder;
            synchronized (localProcessBuilder) {
                if ("PATH".equals(name.toUpperCase(Locale.ENGLISH))) {
                    return this.systemEnvironment.get(this.pathName);
                }
                return this.systemEnvironment.get(name);
            }
        }

        @Override
        public void appendPath(String name, String value) {
            this.putPath(name, value, false);
        }

        @Override
        public void prependPath(String name, String value) {
            this.putPath(name, value, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVariable(String name, String value) {
            LocalProcessBuilder localProcessBuilder = this.builder;
            synchronized (localProcessBuilder) {
                if ("PATH".equals(name.toUpperCase(Locale.ENGLISH))) {
                    this.systemEnvironment.put(this.pathName, value);
                } else {
                    this.systemEnvironment.put(name, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeVariable(String name) {
            LocalProcessBuilder localProcessBuilder = this.builder;
            synchronized (localProcessBuilder) {
                if ("PATH".equals(name.toUpperCase(Locale.ENGLISH))) {
                    this.systemEnvironment.remove(this.pathName);
                } else {
                    this.systemEnvironment.remove(name);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> values() {
            LocalProcessBuilder localProcessBuilder = this.builder;
            synchronized (localProcessBuilder) {
                return new HashMap<String, String>(this.systemEnvironment);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putPath(String name, String value, boolean prepend) {
            LocalProcessBuilder localProcessBuilder = this.builder;
            synchronized (localProcessBuilder) {
                if ("PATH".equals(name.toUpperCase(Locale.ENGLISH))) {
                    ExternalProcessBuilder.putPath(new File(value), this.pathName, prepend, this.systemEnvironment);
                } else {
                    ExternalProcessBuilder.putPath(new File(value), name, prepend, this.systemEnvironment);
                }
            }
        }
    }

    private static class LocalProcessBuilder
    implements ProcessBuilderImplementation {
        private final Environment environment = EnvironmentFactory.createEnvironment(new LocalEnvironment(this, System.getenv()));

        private LocalProcessBuilder() {
        }

        @Override
        public Environment getEnvironment() {
            return this.environment;
        }

        @Override
        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public Process createProcess(ProcessParameters parameters) throws IOException {
            ExternalProcessBuilder builder = new ExternalProcessBuilder(parameters.getExecutable());
            String workingDir = parameters.getWorkingDirectory();
            if (workingDir != null) {
                builder = builder.workingDirectory(new File(workingDir));
            }
            for (String string : parameters.getArguments()) {
                builder = builder.addArgument(string);
            }
            builder = builder.redirectErrorStream(parameters.isRedirectErrorStream());
            for (Map.Entry entry : parameters.getEnvironmentVariables().entrySet()) {
                builder = builder.addEnvironmentVariable((String)entry.getKey(), (String)entry.getValue());
            }
            return builder.call();
        }
    }
}

