---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, travail, commerce, 
              code à barres, gencode, CAB, EAN13
---

# Comment générer des codes à barres ?

## Codes-barres génériques

### Avec l'extension <ctanpkg:ean>

L'extension <ctanpkg:ean> permet de créer des codes-barres à 8 ou 13 chiffres.
Elle marche aussi bien avec TeX qu'avec LaTeX, et utilise METAFONT.

:::{todo} Ajouter un exemple.
:::


### Avec l'extension <ctanpkg:code128>

L'extension <ctanpkg:code128> permet également de faire des codes-barres 
sous TeX comme sous LaTeX. Elle ne nécessite cependant pas l'utilisation 
de fontes particulières.

:::{todo} Ajouter un exemple.
:::


### Avec l'extension <ctanpkg:barcodes>

L'extension <ctanpkg:barcodes> permet, comme son nom l'indique, de faire 
des codes-barres.

:::{todo} Ajouter un exemple.
:::


### Avec l'extension <ctanpkg:barracuda>

:::{todo} Ajouter un exemple.
:::


## Codes-barres pour les livres

L'extension <ctanpkg:ean13isbn> est spécialement adaptée pour l'édition 
de livres : elle permet de configurer 
[l'ISBN](wpfr:International_Standard_Book_Number) du livre comme option 
de l'extension, puis de le faire apparaître à différents endroits, y compris
sous forme de code-barre sur la quatrième de couverture :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[ISBN=978-2-7117-8662-6]{ean13isbn}

\begin{document}
Voici la référence demandée, \ISBN, ainsi que les codes-barres associés :
\begin{figure}[h]
\centering
\begin{tabular}{cc}
\EANisbn & \EANisbn[SC5b] \\ 
\end{tabular}
\end{figure}
\end{document}
```

Dans le cas où la couverture est préparée dans un fichier séparé du reste 
du livre, il est intéressant de mettre l'ISBN du livre à un unique endroit,
dans un fichier `ean13isbn.cfg`, qui contiendra les deux lignes :

```{noedit}
\ProvidesFile{ean13isbn.cfg}
\setkeys{zwean}{ISBN=978-2-7117-8662-6}
```