---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures,
              délimiteurs, ajustement, fantômes, système
---

# Comment gérer des délimiteurs non équilibrés ?

LaTeX propose les commandes bien pratiques `\left` et `\right` pour ajuster 
automatiquement la taille des délimiteurs, comme montré à la question 
"[](/4_domaines_specialises/mathematiques/structures/delimiteurs/ajuster_la_taille_des_delimiteurs)". 
La seule contrainte est que les délimiteurs doivent être équilibrés par paire. 
Voici deux méthodes autour de cette contrainte.


## Cas du délimiteur isolé

Vous pouvez parfois avoir besoin d'un délimiteur unique 
telle l'accolade ouvrante dans un système d'équation. Ici, LaTeX propose 
à cet effet le délimiteur invisible `.` pour compléter la paire 
de délimiteurs. Par exemple, le cas suivant met en face de la commande 
`\left\{` la commande `\right.` :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools} 

\begin{document}
\[ 
  (S) \left\{           % ici on ouvre...
  \begin{aligned}
    ax + by + cz &= 0 \\
    ey + fz &= 0 \\
    gz &= 0
  \end{aligned}
  \right.               % ...et là on ferme !
\]
\end{document}
```

Pour présenter un système d'équation, vous pouvez aussi consulter la question 
"[](/4_domaines_specialises/mathematiques/equations/disposition_d_equations/systemes_d_equations)".


## Cas de délimiteurs trop éloignés

Il est parfois impossible d'équilibrer les délimiteurs, par exemple 
parce qu'ils sont rejettés sur deux lignes différentes faute de place. 
Il faut alors ruser en employant conjointement des délimiteurs invisibles, 
et si besoin des "fantômes" avec la commande `\vphantom` (évoquée à la question 
"[](/3_composition/texte/boites/exploiter_les_fantomes)") pour ajuster
la taille des délimiteurs à un contenu agrandi par le fantôme. Par exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools} 

\begin{document}
\begin{align*}
  a &= \left( \frac{1}{2} + b + c + \ldots \right. \\
    &  \qquad \left.
       \vphantom{\frac{1}{2}} + \ldots + x + y + z \right)^2
\end{align*}
\end{document}
```


:::{sources}
- [Délimiteurs équilibrés ou non](https://www.elzevir.fr/imj/latex/tips.html#lrdelim),
  par Manuel Pégourié-Gonnard
:::