# 2025-02-10 Triage Log

A relatively neutral week, with lots of real changes but most small in
magnitude. Most significant change is rustdoc's move of JS/CSS minification to
build time which cut doc generation times on most benchmarks fairly
significantly.

Triage done by **@simulacrum**.
Revision range: [01e4f19c..c03c38d5](https://perf.rust-lang.org/?start=01e4f19cc8027925ffe0885a86388b700e46bfab&end=c03c38d5c2368cd2aa0e056dba060b94fc747f4e&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 1.2%]   | 100   |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 7.3%]   | 93    |
| Improvements ✅ <br /> (primary)   | -1.8% | [-5.7%, -0.2%] | 22    |
| Improvements ✅ <br /> (secondary) | -2.5% | [-5.7%, -0.2%] | 36    |
| All ❌✅ (primary)                 | 0.0%  | [-5.7%, 1.2%]  | 122   |


3 Regressions, 5 Improvements, 1 Mixed; 2 of them in rollups
32 artifact comparisons made in total

#### Regressions

Upgrade elsa to the newest version. [#136094](https://github.com/rust-lang/rust/pull/136094) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=07179d549659e119a0e4175629b839337c6a8c02&end=820bfffc25fee9866aa8176529091e04b8824f09&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.4%]   | 35    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.0%, 0.6%]   | 13    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.1%, 0.4%]   | 35    |

See discussion
[here](https://github.com/rust-lang/rust/pull/136094#issuecomment-2628827080).
Some possible improvements have been identified, but starting by just getting
elsa on regular updates again.

Rollup of 7 pull requests [#136641](https://github.com/rust-lang/rust/pull/136641) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=79f82ad5e89aa421e2c765fea2098b23beb69b40&end=942db6782f4a28c55b0b75b38fd4394d0483390f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 3.1% | [0.0%, 8.0%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

Changes are expected, from a few contained PRs:
- https://github.com/rust-lang/rust/pull/136073#issuecomment-2617093212
- https://github.com/rust-lang/rust/pull/136435#issuecomment-2629382897

Generally expected to only meaningfully affect stress tests rather than
real-world code.

Add amdgpu target [#134740](https://github.com/rust-lang/rust/pull/134740) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d9a4a47b8b3dc0bdff83360cea2013200d60d49c&end=c03c38d5c2368cd2aa0e056dba060b94fc747f4e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.2%, 3.8%] | 55    |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.2%, 1.0%] | 47    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.2%, 3.8%] | 55    |

Regressions are mostly in LLVM, seemingly due to more logic being added to
common code (e.g., pass enumeration) that runs even on non-AMDGPU targets. This
is also a significant size regression (+19MB on LLVM.so) but generally these
are likely unavoidable in the short term at least given the expanded target
set.

#### Improvements

librustdoc: create a helper for separating elements of an iterator instead of implementing it multiple times [#136244](https://github.com/rust-lang/rust/pull/136244) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e5f11af042ad099102efd572743138df60764a4e&end=8df89d1cb077cd76013d3f9f5a4e92c5b5a9280c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.8%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.7% | [-0.8%, -0.6%] | 2     |


Avoid calling the layout_of query in lit_to_const [#136302](https://github.com/rust-lang/rust/pull/136302) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=820bfffc25fee9866aa8176529091e04b8824f09&end=d4bdd1ed551fed0c951eb47b4be2c79d7a02d181&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.3%] | 14    |
| All ❌✅ (primary)                 | -     | -              | 0     |

rustdoc: run css and html minifier at build instead of runtime [#136253](https://github.com/rust-lang/rust/pull/136253) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d4bdd1ed551fed0c951eb47b4be2c79d7a02d181&end=a9730c3b5f84a001c052c60c97ed0765e9ceac04&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.6% | [-5.5%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -3.7% | [-5.5%, -0.7%] | 22    |
| All ❌✅ (primary)                 | -1.6% | [-5.5%, -0.2%] | 21    |

rustdoc: use ThinVec for generic arg parts [#136265](https://github.com/rust-lang/rust/pull/136265) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6741521dc478182392806e816e919a36be5a2ba2&end=30865107cb8942ab8eaf9baf8d3aa2a6dec2643f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 20    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.1%] | 18    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 20    |


implement `eat_until` leveraging memchr in lexer [#136585](https://github.com/rust-lang/rust/pull/136585) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f92f050e83bf3312ce4ba73c31fe843ad3cbc60&end=79f82ad5e89aa421e2c765fea2098b23beb69b40&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.1%] | 24    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-1.6%, -1.6%] | 1     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.1%] | 24    |

#### Mixed

Rollup of 7 pull requests [#136549](https://github.com/rust-lang/rust/pull/136549) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3f33b30e19b7597a3acbca19e46d9e308865a0fe&end=bef3c3b01f690de16738b1c9f36470fbfc6ac623&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.3%] | 5     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 5     |

Unclear as to exact cause, but not going to dig in further given small number
of benchmarks affected (only primary is `libc`, and it improved).
