# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement.aio import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementWorkspaceNamedValueOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_named_value_list_by_service(self, resource_group):
        response = self.client.workspace_named_value.list_by_service(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_named_value_get_entity_tag(self, resource_group):
        response = await self.client.workspace_named_value.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            named_value_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_named_value_get(self, resource_group):
        response = await self.client.workspace_named_value.get(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            named_value_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_named_value_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.workspace_named_value.begin_create_or_update(
                resource_group_name=resource_group.name,
                service_name="str",
                workspace_id="str",
                named_value_id="str",
                parameters={
                    "displayName": "str",
                    "id": "str",
                    "keyVault": {"identityClientId": "str", "secretIdentifier": "str"},
                    "name": "str",
                    "secret": bool,
                    "tags": ["str"],
                    "type": "str",
                    "value": "str",
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_named_value_begin_update(self, resource_group):
        response = await (
            await self.client.workspace_named_value.begin_update(
                resource_group_name=resource_group.name,
                service_name="str",
                workspace_id="str",
                named_value_id="str",
                if_match="str",
                parameters={
                    "displayName": "str",
                    "keyVault": {"identityClientId": "str", "secretIdentifier": "str"},
                    "secret": bool,
                    "tags": ["str"],
                    "value": "str",
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_named_value_delete(self, resource_group):
        response = await self.client.workspace_named_value.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            named_value_id="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_named_value_list_value(self, resource_group):
        response = await self.client.workspace_named_value.list_value(
            resource_group_name=resource_group.name,
            service_name="str",
            workspace_id="str",
            named_value_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_named_value_begin_refresh_secret(self, resource_group):
        response = await (
            await self.client.workspace_named_value.begin_refresh_secret(
                resource_group_name=resource_group.name,
                service_name="str",
                workspace_id="str",
                named_value_id="str",
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
