# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionAfterReboot(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies what happens after a reboot during the application of a configuration. The possible
    values are ContinueConfiguration and StopConfiguration.
    """

    CONTINUE_CONFIGURATION = "ContinueConfiguration"
    STOP_CONFIGURATION = "StopConfiguration"


class AssignmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the assignment type and execution of the configuration. Possible values are Audit,
    DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
    """

    AUDIT = "Audit"
    DEPLOY_AND_AUTO_CORRECT = "DeployAndAutoCorrect"
    APPLY_AND_AUTO_CORRECT = "ApplyAndAutoCorrect"
    APPLY_AND_MONITOR = "ApplyAndMonitor"


class ComplianceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A value indicating compliance status of the machine for the assigned guest configuration."""

    COMPLIANT = "Compliant"
    NON_COMPLIANT = "NonCompliant"
    PENDING = "Pending"


class ConfigurationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies how the LCM(Local Configuration Manager) actually applies the configuration to the
    target nodes. Possible values are ApplyOnly, ApplyAndMonitor, and ApplyAndAutoCorrect.
    """

    APPLY_ONLY = "ApplyOnly"
    APPLY_AND_MONITOR = "ApplyAndMonitor"
    APPLY_AND_AUTO_CORRECT = "ApplyAndAutoCorrect"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class Kind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of the guest configuration. For example:DSC."""

    DSC = "DSC"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state, which only appears in the response."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    CREATED = "Created"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of report, Consistency or Initial."""

    CONSISTENCY = "Consistency"
    INITIAL = "Initial"
